/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.comment;

import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;
import com.atlassian.servicedesk.internal.comment.SDAttachments;
import com.atlassian.servicedesk.internal.comment.SDComment;
import io.atlassian.fugue.Option;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
public final class SDCommentAndAttachments {
    private final Option<SDComment> sdCommentOption;
    private final SDAttachments sdAttachments;

    private SDCommentAndAttachments(Option<SDComment> sdCommentOption, SDAttachments sdAttachments) {
        this.sdCommentOption = sdCommentOption;
        this.sdAttachments = sdAttachments;
    }

    @Nullable
    public SDComment getSdComment() {
        return (SDComment)this.sdCommentOption.getOrNull();
    }

    public Option<SDComment> getSdCommentOption() {
        return this.sdCommentOption;
    }

    public boolean hasSdComment() {
        return this.sdCommentOption.isDefined();
    }

    public SDAttachments getSdAttachments() {
        return this.sdAttachments;
    }

    public boolean hasSdAttachments() {
        return !this.sdAttachments.getAttachments().isEmpty();
    }

    public static Builder builder() {
        return new Builder();
    }

    @ParametersAreNonnullByDefault
    public static class Builder {
        private Option<SDComment> sdCommentOption = Option.none();
        private Option<SDAttachments> sdAttachmentsOption = Option.none();

        private Builder() {
        }

        public Builder sdComment(SDComment sdComment) {
            this.sdCommentOption = Option.some((Object)sdComment);
            return this;
        }

        public Builder sdAttachments(SDAttachments sdAttachments) {
            this.sdAttachmentsOption = Option.some((Object)sdAttachments);
            return this;
        }

        public SDCommentAndAttachments build() {
            return new SDCommentAndAttachments(this.sdCommentOption, (SDAttachments)this.sdAttachmentsOption.getOrElse((Object)SDAttachments.EMPTY));
        }
    }
}

