/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.comment;

import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.internal.comment.CommentSecurityLevelManager;
import com.atlassian.servicedesk.internal.comment.RoleLevelResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CommentSecurityLevelManagerImpl
implements CommentSecurityLevelManager {
    @Autowired
    private JiraAuthenticationContext jiraAuthenticationContext;
    @Autowired
    private CommentService commentService;
    @Autowired
    private GroupManager groupManager;
    @Autowired
    private ProjectRoleManager projectRoleManager;

    @Override
    public Collection<String> getGroupLevels() {
        List<String> groups;
        if (this.jiraAuthenticationContext.getLoggedInUser() == null || !this.commentService.isGroupVisibilityEnabled()) {
            groups = Collections.emptyList();
        } else {
            Collection groupNames = this.groupManager.getGroupNamesForUser(this.jiraAuthenticationContext.getLoggedInUser().getName());
            ArrayList<String> userGroups = new ArrayList<String>(groupNames);
            Collections.sort(userGroups);
            groups = userGroups;
        }
        return groups;
    }

    @Override
    public Collection<RoleLevelResponse> getRoleLevels(Issue issue) {
        if (this.commentService.isProjectRoleVisibilityEnabled()) {
            ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
            Collection roles = this.projectRoleManager.getProjectRoles(user, issue.getProjectObject());
            ArrayList<RoleLevelResponse> roleLevels = new ArrayList<RoleLevelResponse>();
            for (ProjectRole role : roles) {
                roleLevels.add(new RoleLevelResponse(role.getId(), role.getName()));
            }
            return roleLevels;
        }
        return Collections.emptyList();
    }
}

