/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.comment;

import com.atlassian.jira.event.comment.CommentCreatedEvent;
import com.atlassian.jira.event.comment.CommentUpdatedEvent;
import com.atlassian.jira.event.issue.IssueChangedEvent;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.user.permission.ServiceDeskLicenseAndPermissionService;
import com.atlassian.servicedesk.internal.comment.InternalSDCommentManager;
import com.atlassian.servicedesk.internal.comment.ServiceDeskCommentPropertyService;
import com.atlassian.servicedesk.internal.feature.servicedesk.ServiceDeskInternalManager;
import com.atlassian.servicedesk.internal.util.SafeRunner;
import io.atlassian.fugue.Option;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CommentEventListener {
    private final UserFactory userFactory;
    private final InternalSDCommentManager internalSDCommentManager;
    private final ServiceDeskLicenseAndPermissionService serviceDeskLicenseAndPermissionService;
    private final ServiceDeskCommentPropertyService serviceDeskCommentPropertyService;
    private final ServiceDeskInternalManager serviceDeskInternalManager;
    private final SafeRunner safeRunner;

    @Autowired
    public CommentEventListener(UserFactory userFactory, InternalSDCommentManager internalSDCommentManager, ServiceDeskLicenseAndPermissionService serviceDeskLicenseAndPermissionService, ServiceDeskCommentPropertyService serviceDeskCommentPropertyService, ServiceDeskInternalManager serviceDeskInternalManager, SafeRunner safeRunner) {
        this.userFactory = userFactory;
        this.internalSDCommentManager = internalSDCommentManager;
        this.serviceDeskLicenseAndPermissionService = serviceDeskLicenseAndPermissionService;
        this.serviceDeskCommentPropertyService = serviceDeskCommentPropertyService;
        this.serviceDeskInternalManager = serviceDeskInternalManager;
        this.safeRunner = safeRunner;
    }

    public void onIssueEvent(IssueEvent issueEvent) {
        this.handleComment(issueEvent.getComment());
    }

    public void onCommentCreatedEvent(CommentCreatedEvent event) {
        this.handleComment(event.getComment());
    }

    public void onCommentUpdatedEvent(CommentUpdatedEvent event) {
        this.handleComment(event.getComment());
    }

    public void onIssueChangedEvent(IssueChangedEvent event) {
        event.getComment().ifPresent(this::handleComment);
    }

    private void handleComment(Comment comment) {
        if (comment != null) {
            this.handleComment(comment.getAuthorApplicationUser(), comment);
        }
    }

    private void handleComment(ApplicationUser user, Comment comment) {
        this.userFactory.wrap(user).foreach(checkedUser -> {
            if (this.isServiceDeskProject(comment)) {
                if (this.shouldForceCommentProperty((CheckedUser)checkedUser, comment)) {
                    this.setSDCommentProperty(user, comment, this.internalSDCommentManager.retrieveNonPublicCommentPropertyValue());
                } else {
                    this.getJIRACommentProperty(user, comment).forEach(property -> this.setSDCommentProperty(user, comment, (JSONObject)property));
                }
            }
        });
    }

    private void setSDCommentProperty(ApplicationUser user, Comment comment, JSONObject property) {
        this.safeRunner.run(() -> this.serviceDeskCommentPropertyService.setSDCommentProperty(user, comment, "sd.public.comment", property));
    }

    private Option<JSONObject> getJIRACommentProperty(ApplicationUser user, Comment comment) {
        return this.serviceDeskCommentPropertyService.getJIRACommentProperty(user, comment, "sd.public.comment");
    }

    private boolean shouldForceCommentProperty(CheckedUser checkedUser, Comment comment) {
        return !this.serviceDeskLicenseAndPermissionService.canViewAgentView((SDUser)checkedUser, comment.getIssue()) && !this.internalSDCommentManager.isCommentAllowedToBePublic(checkedUser.forJIRA(), comment);
    }

    private boolean isServiceDeskProject(Comment comment) {
        return this.serviceDeskInternalManager.isServiceDeskEnabled(comment.getIssue().getProjectObject());
    }
}

