/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.capability;

import com.atlassian.fugue.Either;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.pocketknife.api.util.ServiceResult;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.internal.capability.Capability;
import com.atlassian.servicedesk.internal.capability.CapabilityManager;
import com.atlassian.servicedesk.internal.capability.CapabilityService;
import com.google.common.collect.Collections2;
import io.atlassian.fugue.Iterables;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Unit;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CapabilityServiceImpl
implements CapabilityService {
    private final CapabilityManager capabilityManager;
    private static final Function<Capability, String> CAPABILITY_TO_VALUE_FUNCTION = Capability::getValue;
    private static final Predicate<Capability> FIND_CAPABILITY_WITHOUT_USER_KEY_PREDICATE = input -> input.getUserKey().isEmpty();
    private static final Predicate<Capability> FIND_CAPABILITY_WITH_USER_KEY_PREDICATE = input -> input.getUserKey().isDefined();

    @Autowired
    public CapabilityServiceImpl(CapabilityManager capabilityManager) {
        this.capabilityManager = capabilityManager;
    }

    @Override
    public List<Capability> getCapabilities(ServiceDesk serviceDesk) {
        return (List)this.getCapabilities(serviceDesk, (Option<String>)Option.none()).getOrElse(Collections.emptyList());
    }

    @Override
    public Option<List<Capability>> getCapabilities(ServiceDesk serviceDesk, Option<String> name) {
        List capabilities = (List)name.fold(() -> this.capabilityManager.getCapabilities(serviceDesk), input -> {
            io.atlassian.fugue.Either<ErrorCollection, List<Capability>> allCapabilitiesByName = this.capabilityManager.getAllCapabilitiesByName(serviceDesk, (String)input);
            return (List)allCapabilitiesByName.right().getOrNull();
        });
        return Option.option((Object)capabilities);
    }

    @Override
    public Option<String> getCapability(ServiceDesk serviceDesk, String name) {
        return this.getCapability(serviceDesk, name, (Option<String>)Option.none());
    }

    @Override
    public Option<String> getCapability(ServiceDesk serviceDesk, String name, Option<String> userKey) {
        Option options = this.doGetCapability(serviceDesk, name, userKey).right().toOption();
        if (options.isEmpty()) {
            return Option.none();
        }
        return ((Option)options.get()).map(CAPABILITY_TO_VALUE_FUNCTION);
    }

    @Override
    public boolean hasCapability(ServiceDesk serviceDesk, String name) {
        return this.hasCapability(serviceDesk, name, (Option<String>)Option.none());
    }

    @Override
    public boolean hasCapability(ServiceDesk serviceDesk, String name, Option<String> userKey) {
        return ((Option)this.doGetCapability(serviceDesk, name, userKey).right().getOrElse((Object)Option.none())).isDefined();
    }

    @Override
    public io.atlassian.fugue.Either<ErrorCollection, Capability> setCapability(ServiceDesk serviceDesk, String name, String value) {
        return this.setCapability(serviceDesk, name, (Option<String>)Option.none(), value);
    }

    @Override
    public io.atlassian.fugue.Either<ErrorCollection, Capability> setCapability(ServiceDesk serviceDesk, String name, Option<String> userKey, String value) {
        io.atlassian.fugue.Either<ErrorCollection, Option<Capability>> either = this.doGetCapability(serviceDesk, name, userKey);
        if (either.isRight()) {
            Option option = (Option)either.right().get();
            if (option.isEmpty()) {
                Capability capability = new Capability.CapabilityBuilder().name(name).value(value).userKey(userKey).build();
                return this.capabilityManager.createCapability(serviceDesk, capability);
            }
            Capability capability = (Capability)((Object)option.get());
            return this.capabilityManager.updateCapability(serviceDesk, capability, value);
        }
        return io.atlassian.fugue.Either.left((Object)either.left().get());
    }

    @Override
    public io.atlassian.fugue.Either<ErrorCollection, Unit> removeCapability(ServiceDesk serviceDesk, String name) {
        return this.removeCapability(serviceDesk, name, (Option<String>)Option.none());
    }

    @Override
    public io.atlassian.fugue.Either<ErrorCollection, Unit> removeCapability(ServiceDesk serviceDesk, String name, Option<String> userKey) {
        io.atlassian.fugue.Either<ErrorCollection, Option<Capability>> either = this.doGetCapability(serviceDesk, name, userKey);
        if (either.isRight()) {
            Option capability = (Option)either.right().get();
            if (capability.isDefined()) {
                return this.capabilityManager.deleteCapability((Capability)((Object)capability.get()));
            }
            return StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.NOT_FOUND, (String)"sd.capability.removed.not.possible", (Object[])new Object[]{name}));
        }
        return io.atlassian.fugue.Either.left((Object)either.left().get());
    }

    private io.atlassian.fugue.Either<ErrorCollection, Option<Capability>> doGetCapability(ServiceDesk serviceDesk, String name, Option<String> userKey) {
        final List capabilities = (List)this.getCapabilities(serviceDesk, (Option<String>)Option.option((Object)name)).getOrElse(Collections.emptyList());
        if (capabilities.isEmpty()) {
            return io.atlassian.fugue.Either.right((Object)Option.none());
        }
        Option result = (Option)userKey.fold((Supplier)new Supplier<Option<Option<Capability>>>(){

            @Override
            public Option<Option<Capability>> get() {
                boolean anyHaveUserKey = Iterables.any((Iterable)capabilities, (Predicate)FIND_CAPABILITY_WITH_USER_KEY_PREDICATE);
                if (!anyHaveUserKey && capabilities.size() == 1) {
                    return Option.some((Object)Iterables.first((Iterable)capabilities));
                }
                return Option.none();
            }
        }, (Function)new Function<String, Option<Option<Capability>>>(){

            @Override
            public Option<Option<Capability>> apply(String key) {
                boolean anyWithoutUserKey = Iterables.any((Iterable)capabilities, (Predicate)FIND_CAPABILITY_WITHOUT_USER_KEY_PREDICATE);
                if (anyWithoutUserKey) {
                    return Option.none();
                }
                Collection filtered = Collections2.filter((Collection)capabilities, input2 -> input2 != null && input2.getUserKey().exists(input -> Objects.equals(key, input)));
                switch (filtered.size()) {
                    case 0: {
                        return Option.some((Object)Option.none());
                    }
                    case 1: {
                        return Option.some((Object)Iterables.first((Iterable)filtered));
                    }
                }
                return Option.none();
            }
        });
        if (result.isEmpty()) {
            return StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.CONFLICT, (String)"sd.capability.get.not.unique", (Object[])new Object[0]));
        }
        return io.atlassian.fugue.Either.right((Object)result.get());
    }
}

