/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.capability;

import com.atlassian.fugue.Either;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.pocketknife.api.util.ServiceResult;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.internal.capability.Capability;
import com.atlassian.servicedesk.internal.capability.CapabilityManager;
import com.atlassian.servicedesk.internal.capability.CapabilityQStore;
import com.atlassian.servicedesk.internal.utils.CacheUtil;
import com.atlassian.vcache.RequestCache;
import com.atlassian.vcache.VCacheFactory;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Unit;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CapabilityManagerImpl
implements CapabilityManager {
    private final CapabilityQStore capabilityQStore;
    private final RequestCache<Integer, List<Capability>> capabilitiesCache;

    @Autowired
    public CapabilityManagerImpl(CapabilityQStore capabilityQStore, VCacheFactory cacheFactory) {
        this.capabilityQStore = capabilityQStore;
        this.capabilitiesCache = cacheFactory.getRequestCache(CacheUtil.standardName(this, "capabilitiesCache"));
    }

    @Override
    public List<Capability> getCapabilities(ServiceDesk serviceDesk) {
        List cachedCapabilities = (List)this.capabilitiesCache.get((Object)serviceDesk.getId(), () -> this.capabilityQStore.getCapabilitiesByServiceDesk(serviceDesk));
        return new ArrayList<Capability>(cachedCapabilities);
    }

    @Override
    public io.atlassian.fugue.Either<ErrorCollection, List<Capability>> getAllCapabilitiesByName(ServiceDesk serviceDesk, final String name) {
        ArrayList capabilities = Lists.newArrayList((Iterable)Collections2.filter(this.getCapabilities(serviceDesk), (Predicate)new Predicate<Capability>(){

            public boolean apply(Capability input) {
                return Objects.equals(name, input.getName());
            }
        }));
        if (capabilities.isEmpty()) {
            return StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.NOT_FOUND, (String)"capability not found", (Object[])new Object[0]));
        }
        return io.atlassian.fugue.Either.right((Object)capabilities);
    }

    @Override
    public io.atlassian.fugue.Either<ErrorCollection, Capability> updateCapability(ServiceDesk serviceDesk, Capability capability, String updatedValue) {
        io.atlassian.fugue.Either<ErrorCollection, Unit> validate2 = this.validate(serviceDesk, capability);
        if (validate2.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)validate2.left().get());
        }
        return (io.atlassian.fugue.Either)this.capabilityQStore.updateCapability(capability, updatedValue).fold(() -> StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.NOT_FOUND, (String)"capability not found", (Object[])new Object[0])), updatedCapability -> {
            this.invalidateCache(serviceDesk.getId());
            return io.atlassian.fugue.Either.right((Object)updatedCapability);
        });
    }

    @Override
    public io.atlassian.fugue.Either<ErrorCollection, Capability> createCapability(ServiceDesk serviceDesk, Capability capability) {
        io.atlassian.fugue.Either<ErrorCollection, Unit> validate2 = this.validate(serviceDesk, capability);
        if (validate2.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)validate2.left().get());
        }
        Option<Capability> insertedCapability = this.capabilityQStore.createCapabilityForServiceDesk(serviceDesk, capability);
        this.invalidateCache(serviceDesk.getId());
        return (io.atlassian.fugue.Either)insertedCapability.fold(() -> StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.SERVER_ERROR, (String)"sd.error.can.not.create", (Object[])new Object[]{"Capability"})), io.atlassian.fugue.Either::right);
    }

    @Override
    public io.atlassian.fugue.Either<ErrorCollection, Unit> deleteCapability(Capability capability) {
        return (io.atlassian.fugue.Either)this.capabilityQStore.getCapabilityServiceDeskId(capability.getId()).fold(() -> StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.NOT_FOUND, (String)"capability not found", (Object[])new Object[0])), serviceDeskId -> this.invalidateAndDeleteCapability((int)serviceDeskId, capability));
    }

    private io.atlassian.fugue.Either<ErrorCollection, Unit> invalidateAndDeleteCapability(int serviceDeskId, Capability capability) {
        this.invalidateCache(serviceDeskId);
        this.capabilityQStore.deleteCapabilityById(capability.getId());
        return io.atlassian.fugue.Either.right((Object)Unit.Unit());
    }

    @Override
    public io.atlassian.fugue.Either<ErrorCollection, Unit> deleteAllCapabilitiesInServiceDesk(ServiceDesk serviceDesk) {
        this.invalidateCache(serviceDesk.getId());
        this.capabilityQStore.deleteCapabilitiesForServiceDesk(serviceDesk);
        return io.atlassian.fugue.Either.right((Object)Unit.Unit());
    }

    @Override
    public io.atlassian.fugue.Either<ErrorCollection, Unit> validate(ServiceDesk serviceDesk, Capability capability) {
        String finalName = StringUtils.trimToEmpty((String)capability.getName());
        if (finalName.isEmpty()) {
            return StepsConverters.newerEither((Either)ServiceResult.error((String)"name", (ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED, (String)"sd.capability.name.required", (Object[])new Object[0]));
        }
        if (finalName.length() > 255) {
            return StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED, (String)"sd.capability.name.too.long", (Object[])new Object[0]));
        }
        capability = Capability.builder(capability).name(finalName).build();
        this.invalidateCache(serviceDesk.getId());
        List<Capability> capabilities = this.getCapabilities(serviceDesk);
        if (this.nameInUse(capability, capabilities)) {
            return StepsConverters.newerEither((Either)ServiceResult.error((String)"name", (ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED, (String)"sd.capability.name.used", (Object[])new Object[0]));
        }
        return io.atlassian.fugue.Either.right((Object)Unit.Unit());
    }

    private boolean nameInUse(Capability capability, List<Capability> forParent) {
        for (Capability ao : forParent) {
            if (capability.getId() != null && Objects.equals(capability.getId(), ao.getId()) || !Objects.equals(ao.getName(), capability.getName())) continue;
            if (capability.getUserKey().isEmpty()) {
                return true;
            }
            if (!ao.getUserKey().isEmpty() && !Objects.equals(ao.getUserKey(), capability.getUserKey())) continue;
            return true;
        }
        return false;
    }

    private void invalidateCache(Integer serviceDeskId) {
        this.capabilitiesCache.remove((Object)serviceDeskId);
    }
}

