/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.cache;

import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.vcache.ExternalWriteOperationsUnbuffered;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CacheClearer {
    private static final Logger log = LoggerFactory.getLogger(CacheClearer.class);
    private final List<Runnable> cacheClearingSideEffects = new CopyOnWriteArrayList<Runnable>();

    public void onClearCache(ClearCacheEvent clearCacheEvent) {
        log.warn("Clearing the JSD plugin caches...");
        this.cacheClearingSideEffects.forEach(Runnable::run);
        log.warn("Cleared the JSD plugin caches!");
    }

    public void registerCacheClearing(Runnable runnable) {
        this.cacheClearingSideEffects.add(Objects.requireNonNull(runnable));
    }

    public void waitForCacheClear(ExternalWriteOperationsUnbuffered<?> cache) {
        CompletionStage completionStage = cache.removeAll();
        try {
            completionStage.toCompletableFuture().get(1L, TimeUnit.MINUTES);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

