/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.automation.rulewhen;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.api.search.issue.util.NumberUtil;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.feature.servicedesk.InternalServiceDeskService;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.InternalTimeMetricService;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetric;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.ConfigurationData;
import com.atlassian.servicedesk.plugins.automation.spi.visualiser.RuleComponentVisualiser;
import com.atlassian.servicedesk.workinprogressapi.sla.urgencylevel.UrgencyLevel;
import com.atlassian.servicedesk.workinprogressapi.sla.urgencylevel.UrgencyLevelService;
import io.atlassian.fugue.Option;
import javax.annotation.Nonnull;

public class SLAThresholdEventWhenHandlerVisualiser
implements RuleComponentVisualiser {
    private final I18nHelper i18n;
    private final InternalTimeMetricService timeMetricService;
    private final InternalServiceDeskService serviceDeskService;
    private final UrgencyLevelService urgencyLevelService;
    private final UserFactory userFactory;

    public SLAThresholdEventWhenHandlerVisualiser(I18nHelper i18nHelper, InternalTimeMetricService timeMetricService, InternalServiceDeskService serviceDeskService, UrgencyLevelService urgencyLevelService, UserFactory userFactory) {
        this.i18n = i18nHelper;
        this.timeMetricService = timeMetricService;
        this.serviceDeskService = serviceDeskService;
        this.urgencyLevelService = urgencyLevelService;
        this.userFactory = userFactory;
    }

    @Nonnull
    public String getName(@Nonnull RuleComponentVisualiser.RuleComponentVisualiserParam ruleComponentVisualiserParam) {
        return this.i18n.getText("sd.sla.threshold.when.name");
    }

    @Nonnull
    public com.atlassian.fugue.Option<String> getLabel(@Nonnull RuleComponentVisualiser.RuleComponentVisualiserParam ruleComponentVisualiserParam) {
        ApplicationUser user = ruleComponentVisualiserParam.getUser();
        ConfigurationData configurationData = ruleComponentVisualiserParam.ruleConfiguration();
        String thresholdLabel = this.i18n.getText(this.getThresholdLabelKey(configurationData));
        for (ServiceDesk serviceDesk : this.getServiceDeskFromConfiguration(user, configurationData)) {
            com.atlassian.fugue.Option<TimeMetric> timeMetricOpt = this.getTimeMetricFromConfiguration(user, serviceDesk, configurationData);
            if (!timeMetricOpt.isDefined()) continue;
            String name = ((TimeMetric)((Object)timeMetricOpt.get())).getName();
            return com.atlassian.fugue.Option.some((Object)this.i18n.getText("sd.sla.threshold.when.visualisation", name, thresholdLabel));
        }
        return com.atlassian.fugue.Option.none();
    }

    private com.atlassian.fugue.Option<TimeMetric> getTimeMetricFromConfiguration(ApplicationUser user, ServiceDesk serviceDesk, ConfigurationData configurationData) {
        com.atlassian.fugue.Option rawMetricIdOpt = configurationData.getValue("metricId");
        for (String raw : rawMetricIdOpt) {
            com.atlassian.fugue.Option metricIdOpt = com.atlassian.fugue.Option.option((Object)NumberUtil.toLong((String)raw));
            if (!metricIdOpt.isDefined()) continue;
            return StepsConverters.olderOption((Option)this.timeMetricService.getTimeMetric(user, serviceDesk, ((Long)metricIdOpt.get()).intValue()).right().toOption());
        }
        return com.atlassian.fugue.Option.none();
    }

    private String getThresholdLabelKey(ConfigurationData configurationData) {
        com.atlassian.fugue.Option urgencyLevelForRemainingTime;
        com.atlassian.fugue.Option thresholdMillisOpt;
        com.atlassian.fugue.Option thresholdMillisRawOpt = configurationData.getValue("thresholdTime");
        if (thresholdMillisRawOpt.isDefined() && (thresholdMillisOpt = com.atlassian.fugue.Option.option((Object)NumberUtil.toLong((String)((String)thresholdMillisRawOpt.get())))).isDefined() && (urgencyLevelForRemainingTime = StepsConverters.olderOption(this.urgencyLevelService.getUrgencyLevelForRemainingTime((Long)thresholdMillisOpt.get()))).isDefined()) {
            return ((UrgencyLevel)urgencyLevelForRemainingTime.get()).getKey();
        }
        return "sd.sla.urgency.unknown";
    }

    private com.atlassian.fugue.Option<ServiceDesk> getServiceDeskFromConfiguration(ApplicationUser user, ConfigurationData configurationData) {
        return Steps.begin((com.atlassian.fugue.Option)this.userFactory.wrap(user).toOption()).then(checkedUser -> configurationData.getValue("projectKey")).then((checkedUser, projectKey) -> StepsConverters.olderOption((Option)this.serviceDeskService.getServiceDeskForKey(checkedUser, projectKey, false).toOption())).yield((checkedUser, projectKey, serviceDesk) -> serviceDesk);
    }
}

