/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.automation.blueprints;

import com.atlassian.fugue.Either;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.HttpStatusCode;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.servicedesk.internal.automation.defaultrule.DefaultAutomationRuleData;
import com.atlassian.servicedesk.internal.automation.defaultrule.DefaultAutomationRuleService;
import com.atlassian.servicedesk.internal.automation.defaultrule.DefaultAutomationRuleServiceImpl;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.input.RuleSetInput;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.input.RuleSetInputBuilder;
import com.atlassian.servicedesk.plugins.automation.spi.blueprint.Blueprint;
import java.util.List;
import javax.annotation.Nonnull;

public class TransitionOnCommentBlueprint
implements Blueprint {
    private final DefaultAutomationRuleService defaultAutomationRuleService;
    private final ErrorResultHelper errorResultHelper;
    private final I18nHelper.BeanFactory i18nFactory;
    private final String WAITING_FOR_SUPPORT_KEY = "sd.workflow.itsupport.v2.step.name.waiting.for.support";
    private final String WAITING_FOR_CUSTOMER_KEY = "sd.workflow.itsupport.v2.step.name.waiting.for.customer";
    private final String TO_SUPPORT_ACTION_KEY = "sd.workflow.itsupport.v2.transition.respond.to.support.name";
    private final String TO_CUSTOMER_ACTION_KEY = "sd.workflow.itsupport.v2.transition.respond.to.customer.name";

    public TransitionOnCommentBlueprint(DefaultAutomationRuleService defaultAutomationRuleService, ErrorResultHelper errorResultHelper, I18nHelper.BeanFactory i18nFactory) {
        this.defaultAutomationRuleService = defaultAutomationRuleService;
        this.errorResultHelper = errorResultHelper;
        this.i18nFactory = i18nFactory;
    }

    public Either<AnError, RuleSetInput> generateRuleSetInput(@Nonnull Blueprint.BlueprintParam blueprintParam) {
        if (this.defaultAutomationRuleService instanceof DefaultAutomationRuleServiceImpl) {
            DefaultAutomationRuleServiceImpl defaultRuleCreationServiceImpl = (DefaultAutomationRuleServiceImpl)this.defaultAutomationRuleService;
            ApplicationUser currentUser = blueprintParam.getUser();
            I18nHelper i18n = this.i18nFactory.getInstance(currentUser);
            I18nHelper serverI18n = this.i18nFactory.getInstance((ApplicationUser)null);
            List projectList = blueprintParam.getProjectContext().getProjects();
            if (projectList.isEmpty()) {
                return this.errorResultHelper.error(HttpStatusCode.BAD_REQUEST, "sd.automation.blueprint.error.missing.project", new Object[0]);
            }
            Project project = (Project)projectList.get(0);
            DefaultAutomationRuleData ruleData = new DefaultAutomationRuleData(serverI18n.getText("sd.workflow.itsupport.v2.step.name.waiting.for.support"), serverI18n.getText("sd.workflow.itsupport.v2.step.name.waiting.for.customer"), serverI18n.getText("sd.workflow.itsupport.v2.transition.respond.to.customer.name"), serverI18n.getText("sd.workflow.itsupport.v2.transition.respond.to.support.name"));
            RuleSetInputBuilder builder = defaultRuleCreationServiceImpl.createBuilder(project, i18n.getText("sd.automation.blueprint.comment.transition.name"), i18n.getText("sd.automation.blueprint.comment.transition.description"), ruleData);
            return Either.right((Object)builder.build());
        }
        return this.errorResultHelper.error(HttpStatusCode.INTERNAL_SERVER_ERROR, "sd.automation.blueprint.error.bridge.failure", new Object[0]);
    }
}

