/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.automation.blueprints;

import com.atlassian.fugue.Either;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.HttpStatusCode;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.input.BuilderService;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.input.RuleSetInput;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.input.RuleSetInputBuilder;
import com.atlassian.servicedesk.plugins.automation.spi.blueprint.Blueprint;
import java.util.List;

public class ReopoenOnCommentBlueprint
implements Blueprint {
    private static final String SERVICE_DESK_AUTOMATION_MODULES_PLUGIN_KEY = "com.atlassian.servicedesk.plugins.automation.servicedesk-automation-modules-plugin";
    private static final String ISSUE_COMMENTED_WHEN_HANDLER_MODULE_KEY = "servicedesk-commented-automation-rule-when-handler";
    private static final String ISSUE_COMMENTED_WHEN_HANDLER_COMPLETE_KEY = "com.atlassian.servicedesk.plugins.automation.servicedesk-automation-modules-plugin:servicedesk-commented-automation-rule-when-handler";
    private static final String WORKFLOW_TRANSITION_THEN_ACTION_MODULE_KEY = "workflow-transition-action";
    private static final String WORKFLOW_TRANSITION_THEN_ACTION_COMPLETE_KEY = "com.atlassian.servicedesk.plugins.automation.servicedesk-automation-modules-plugin:workflow-transition-action";
    private static final String JQL_IF_CONDITION_MODULE_KEY = "jql-if-condition";
    private static final String JQL_IF_CONDITION_COMPLETE_KEY = "com.atlassian.servicedesk.plugins.automation.servicedesk-automation-modules-plugin:jql-if-condition";
    private static final String COMMENT_VISIBILITY_MODULE_KEY = "sd-comment-visibility-if-condition";
    private static final String COMMENT_VISIBILITY_MODULE_COMPLETE_KEY = "com.atlassian.servicedesk.plugins.automation.servicedesk-automation-modules-plugin:sd-comment-visibility-if-condition";
    private static final String USER_TYPE_MODULE_KEY = "sd-user-role-if-condition";
    private static final String USER_TYPE_MODULE_COMPLETE_KEY = "com.atlassian.servicedesk.plugins.automation.servicedesk-automation-modules-plugin:sd-user-role-if-condition";
    private final BuilderService builderService;
    private final ErrorResultHelper errorResultHelper;
    private final I18nHelper.BeanFactory i18nFactory;

    public ReopoenOnCommentBlueprint(BuilderService builderService, ErrorResultHelper errorResultHelper, I18nHelper.BeanFactory i18nFactory) {
        this.builderService = builderService;
        this.errorResultHelper = errorResultHelper;
        this.i18nFactory = i18nFactory;
    }

    public Either<AnError, RuleSetInput> generateRuleSetInput(Blueprint.BlueprintParam blueprintParam) {
        ApplicationUser currentUser = blueprintParam.getUser();
        List projectList = blueprintParam.getProjectContext().getProjects();
        if (projectList.isEmpty()) {
            return this.errorResultHelper.error(HttpStatusCode.BAD_REQUEST, "sd.automation.blueprint.error.missing.project", new Object[0]);
        }
        Project project = (Project)projectList.get(0);
        RuleSetInputBuilder reopenOnCommentRuleBuilder = this.createReopenOnCommentRule(currentUser, project);
        return Either.right((Object)reopenOnCommentRuleBuilder.build());
    }

    private RuleSetInputBuilder createReopenOnCommentRule(ApplicationUser user, Project project) {
        I18nHelper i18n = this.i18nFactory.getInstance(user);
        I18nHelper serverI18n = this.i18nFactory.getInstance((ApplicationUser)null);
        RuleSetInputBuilder ruleSetInputBuilder = this.builderService.newRuleSetBuilder().name(i18n.getText("sd.automation.blueprint.comment.reopen.name")).description(i18n.getText("sd.automation.blueprint.comment.reopen.description")).metadata().projectContext().project(project).endProjectContext().triggerFromOtherRules(Boolean.valueOf(true)).endMetadata();
        RuleSetInputBuilder.RuleBuilder ruleBuilder = ruleSetInputBuilder.rule();
        this.addCommentWhen(ruleBuilder);
        this.addReopenIssue(ruleBuilder, serverI18n.getText("sd.workflow.itsupport.v2.step.name.resolved"), serverI18n.getText("sd.workflow.itsupport.v2.transition.reopen.issue.name"));
        ruleBuilder.endRule();
        return ruleBuilder.endRule();
    }

    private RuleSetInputBuilder.RuleBuilder addReopenIssue(RuleSetInputBuilder.RuleBuilder builder, String statusName, String actionName) {
        RuleSetInputBuilder.IfBuilder ifBuilder = builder.ifThen().ruleIf();
        this.ifJQLCondition(ifBuilder, statusName);
        this.ifCommentIsPublic(ifBuilder);
        this.ifUserIsInRole(ifBuilder, "customer");
        RuleSetInputBuilder.ThenBuilder thenBuilder = ifBuilder.endIf().ruleThen();
        this.thenTransition(thenBuilder, actionName);
        thenBuilder.endThen().endIfThen();
        return builder;
    }

    private RuleSetInputBuilder.IfBuilder ifJQLCondition(RuleSetInputBuilder.IfBuilder builder, String statusName) {
        builder.ifCondition().moduleKey(JQL_IF_CONDITION_COMPLETE_KEY).data(this.builderService.newConfigurationDataBuilder().put("jql", "Status = \"" + statusName + "\"").build()).endIfCondition();
        return builder;
    }

    private RuleSetInputBuilder.IfBuilder ifCommentIsPublic(RuleSetInputBuilder.IfBuilder builder) {
        builder.ifCondition().moduleKey(COMMENT_VISIBILITY_MODULE_COMPLETE_KEY).data(this.builderService.newConfigurationDataBuilder().put("commentType", "public").build()).endIfCondition();
        return builder;
    }

    public RuleSetInputBuilder.IfBuilder ifUserIsInRole(RuleSetInputBuilder.IfBuilder builder, String userType) {
        builder.ifCondition().moduleKey(USER_TYPE_MODULE_COMPLETE_KEY).data(this.builderService.newConfigurationDataBuilder().put("userRoleType", userType).build()).endIfCondition();
        return builder;
    }

    private RuleSetInputBuilder.RuleBuilder addCommentWhen(RuleSetInputBuilder.RuleBuilder builder) {
        builder.when().whenHandler().moduleKey(ISSUE_COMMENTED_WHEN_HANDLER_COMPLETE_KEY).endWhenHandler().endWhen();
        return builder;
    }

    private RuleSetInputBuilder.ThenBuilder thenTransition(RuleSetInputBuilder.ThenBuilder builder, String actionName) {
        builder.thenAction().moduleKey(WORKFLOW_TRANSITION_THEN_ACTION_COMPLETE_KEY).data(this.builderService.newConfigurationDataBuilder().put("workflowAction", actionName).build()).endThenAction();
        return builder;
    }
}

