/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.automation;

import com.atlassian.fugue.Either;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.api.customer.CustomerContextService;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessage;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessageBuilderService;
import com.atlassian.servicedesk.plugins.automation.internal.spi.execution.RuleExecutionPreprocessor;
import javax.annotation.Nonnull;

public class CustomerContextRuleExecutionPreprocessor
implements RuleExecutionPreprocessor {
    public static final String IN_CUSTOMER_CONTEXT_KEY = "inCustomerContext";
    private final CustomerContextService customerContextService;
    private final RuleMessageBuilderService ruleMessageBuilderService;

    public CustomerContextRuleExecutionPreprocessor(CustomerContextService customerContextService, RuleMessageBuilderService ruleMessageBuilderService) {
        this.customerContextService = customerContextService;
        this.ruleMessageBuilderService = ruleMessageBuilderService;
    }

    public Either<AnError, RuleMessage> preprocess(@Nonnull RuleExecutionPreprocessor.PreprocessorParams preprocessorParams) {
        if (this.customerContextService.isInCustomerContext()) {
            RuleMessage updatedRuleMessage = this.ruleMessageBuilderService.builder(preprocessorParams.getRuleMessage()).putValue(IN_CUSTOMER_CONTEXT_KEY, Boolean.TRUE.toString()).build();
            return Either.right((Object)updatedRuleMessage);
        }
        return Either.right((Object)preprocessorParams.getRuleMessage());
    }
}

