/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.automation;

import com.atlassian.servicedesk.api.customer.CustomerContextService;
import com.atlassian.servicedesk.plugins.automation.internal.spi.execution.RuleExecutionInterceptor;

public class CustomerContextRuleExecutionInterceptor
implements RuleExecutionInterceptor {
    private final CustomerContextService customerContextService;

    public CustomerContextRuleExecutionInterceptor(CustomerContextService customerContextService) {
        this.customerContextService = customerContextService;
    }

    public void doIntercept(RuleExecutionInterceptor.RuleExecutionParam ruleExecutionParam, RuleExecutionInterceptor.InterceptorChain interceptorChain) {
        boolean inCustomerContext = (Boolean)ruleExecutionParam.getRuleMessage().getValue("inCustomerContext").map(Boolean::parseBoolean).getOrElse((Object)false);
        if (inCustomerContext) {
            this.customerContextService.runInCustomerContext(() -> ((RuleExecutionInterceptor.InterceptorChain)interceptorChain).next());
        } else {
            this.customerContextService.runOutOfCustomerContext(() -> ((RuleExecutionInterceptor.InterceptorChain)interceptorChain).next());
        }
    }

    public void doIntercept(RuleExecutionInterceptor.WhenExecutionParam whenExecutionParam, RuleExecutionInterceptor.InterceptorChain interceptorChain) {
        interceptorChain.next();
    }
}

