/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.automation;

import com.atlassian.fugue.Either;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.automation.AutomationBridge;
import com.atlassian.servicedesk.internal.user.permission.ServiceDeskPermissions;
import com.atlassian.servicedesk.internal.util.SafeRunner;
import com.atlassian.servicedesk.plugins.automation.api.configuration.project.ProjectRunAsUserContextConfigService;
import com.atlassian.servicedesk.plugins.automation.api.configuration.user.RunAsSpecificUserContextConfig;
import com.atlassian.servicedesk.plugins.automation.api.configuration.user.RunAsUserContextConfig;
import com.atlassian.servicedesk.plugins.automation.api.experimental.serviceflags.PermissionCheckFlag;
import com.atlassian.servicedesk.plugins.automation.api.experimental.serviceflags.ServiceFlag;
import com.atlassian.servicedesk.plugins.automation.api.experimental.serviceflags.ServiceFlags;
import io.atlassian.fugue.Option;

public class AutomationBridgeImpl
implements AutomationBridge {
    private final UserManager userManager;
    private final SafeRunner safeRunner;
    private final ServiceDeskPermissions sdPermissions;
    private final UserFactory userFactory;

    public AutomationBridgeImpl(UserManager userManager, SafeRunner safeRunner, ServiceDeskPermissions sdPermissions, UserFactory userFactory) {
        this.userManager = userManager;
        this.safeRunner = safeRunner;
        this.sdPermissions = sdPermissions;
        this.userFactory = userFactory;
    }

    @Override
    public Boolean isTheRunAsUserContextConfigInvalid(ApplicationUser user, Project project) {
        Option<ProjectRunAsUserContextConfigService> serviceOpt = this.getAutomationServiceOfType(ProjectRunAsUserContextConfigService.class);
        if (serviceOpt.isEmpty()) {
            return false;
        }
        ProjectRunAsUserContextConfigService projectRunAsUserContextConfigService = (ProjectRunAsUserContextConfigService)serviceOpt.get();
        Option<RunAsUserContextConfig> runAsUserContextConfigOpt = this.loadRunAsUserContextConfigForProject(projectRunAsUserContextConfigService, user, project);
        if (runAsUserContextConfigOpt.isEmpty()) {
            return false;
        }
        RunAsUserContextConfig runAsUserContextConfig = (RunAsUserContextConfig)runAsUserContextConfigOpt.get();
        RunAsSpecificUserContextConfig runAsSpecificUserContextConfig = (RunAsSpecificUserContextConfig)runAsUserContextConfig;
        String configuredUserKey = runAsSpecificUserContextConfig.getUserKey();
        ApplicationUser specificUser = this.userManager.getUserByKey(configuredUserKey);
        io.atlassian.fugue.Either uncheckedUserEither = StepsConverters.newerEither((Either)this.userFactory.wrapUnchecked(specificUser));
        return (Boolean)uncheckedUserEither.fold(e -> true, uncheckedUser -> !this.sdPermissions.canBrowseAndEdit((SDUser)uncheckedUser, project));
    }

    private Option<RunAsUserContextConfig> loadRunAsUserContextConfigForProject(ProjectRunAsUserContextConfigService projectRunAsUserContextConfigService, ApplicationUser user, Project project) {
        Option<io.atlassian.fugue.Either> getConfigResult = this.safeRunner.call(() -> StepsConverters.newerEither((Either)projectRunAsUserContextConfigService.getContextConfigForProject(user, project, ServiceFlags.of((ServiceFlag[])new ServiceFlag[]{PermissionCheckFlag.SKIP_PERMISSION_CHECK}))).map(StepsConverters::newerOption));
        if (getConfigResult.isEmpty() || ((io.atlassian.fugue.Either)getConfigResult.get()).isLeft()) {
            return Option.none();
        }
        return (Option)((io.atlassian.fugue.Either)getConfigResult.get()).right().get();
    }

    private <T> Option<T> getAutomationServiceOfType(Class<T> serviceClass) {
        Object osgiComponent = ComponentAccessor.getOSGiComponentInstanceOfType(serviceClass);
        if (osgiComponent == null) {
            return Option.none();
        }
        return Option.some((Object)osgiComponent);
    }
}

