/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.audit;

import com.atlassian.jira.auditing.AffectedProject;
import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.AuditingCategory;
import com.atlassian.jira.auditing.AuditingService;
import com.atlassian.jira.auditing.ChangedValueImpl;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.internal.api.audit.ServiceDeskAuditLogger;
import com.atlassian.servicedesk.internal.feature.customer.portal.PortalInternal;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class ServiceDeskAuditLoggerImpl
implements ServiceDeskAuditLogger {
    private final AuditingService auditingService;
    private final ProjectManager projectManager;

    @Autowired
    public ServiceDeskAuditLoggerImpl(AuditingService auditingService, ProjectManager projectManager) {
        this.auditingService = auditingService;
        this.projectManager = projectManager;
    }

    public void logRequestTypeChanged(RequestType oldRequestType, RequestType newRequestType, Portal portal) {
        long projectId = ((PortalInternal)portal).getProjectId();
        Project project = this.projectManager.getProjectObj(Long.valueOf(projectId));
        ArrayList changedValues = Lists.newArrayList();
        ArrayList affectedItems = Lists.newArrayList();
        if (oldRequestType.getIconId() != newRequestType.getIconId()) {
            changedValues.add(new ChangedValueImpl("icon", oldRequestType.getIconId() + "", newRequestType.getIconId() + ""));
        }
        if (oldRequestType.getIssueTypeId() != newRequestType.getIssueTypeId()) {
            changedValues.add(new ChangedValueImpl("issueType", oldRequestType.getIssueTypeId() + "", newRequestType.getIssueTypeId() + ""));
        }
        if (!StringUtils.equals((String)oldRequestType.getHelpText(), (String)newRequestType.getHelpText())) {
            changedValues.add(new ChangedValueImpl("helptext", oldRequestType.getHelpText(), newRequestType.getHelpText()));
        }
        if (!StringUtils.equals((String)oldRequestType.getName(), (String)newRequestType.getName())) {
            changedValues.add(new ChangedValueImpl("name", oldRequestType.getName(), newRequestType.getName()));
        }
        if (!StringUtils.equals((String)oldRequestType.getDescription(), (String)newRequestType.getDescription())) {
            changedValues.add(new ChangedValueImpl("description", oldRequestType.getDescription(), newRequestType.getDescription()));
        }
        if (changedValues.size() > 0) {
            AffectedProject affectedProject = new AffectedProject(project);
            affectedItems.add(affectedProject);
            this.auditingService.storeRecord(AuditingCategory.PROJECTS.getId(), "Request type changed", (AssociatedItem)affectedProject, (Iterable)changedValues, (Iterable)affectedItems, null);
        }
    }
}

