/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.applink;

import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.servicedesk.internal.api.applink.ApplicationLinkErrors;
import com.atlassian.servicedesk.internal.applink.GenericAppLinkResponseHandler;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;

public class GenericAppLinkResponseHandlerImpl
extends GenericAppLinkResponseHandler {
    public GenericAppLinkResponseHandlerImpl(ApplicationLinkErrors applicationLinkErrors, ErrorResultHelper errorResultHelper) {
        super(applicationLinkErrors, errorResultHelper);
    }

    public Either<AnError, JsonNode> onCredentialError(String responseBody) {
        log.error("Unsupported or misconfigured application link authentication settings, check the settings in application links: {}", (Object)responseBody);
        return Either.left((Object)this.applicationLinkErrors.INVALID_APP_LINK_CONFIGURATION());
    }

    public Either<AnError, JsonNode> onError(String responseBody, int statusCode) {
        log.error("Applink request has returned an error with status code {}: {}", (Object)statusCode, (Object)responseBody);
        return Either.left((Object)this.applicationLinkErrors.GENERIC_COMMUNICATION_ERROR());
    }

    public Either<AnError, JsonNode> onSuccess(String responseBody) {
        Option jsonObjectOption = this.toJsonObject(responseBody);
        JsonNode jsonNode = (JsonNode)jsonObjectOption.getOr(() -> {
            ObjectMapper objectMapper = new ObjectMapper();
            return objectMapper.createObjectNode();
        });
        return Either.right((Object)jsonNode);
    }
}

