/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.analytics;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.event.comment.CommentCreatedEvent;
import com.atlassian.jira.event.comment.CommentDeletedEvent;
import com.atlassian.jira.event.comment.CommentUpdatedEvent;
import com.atlassian.jira.event.issue.IssueChangedEvent;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.customer.CustomerContextService;
import com.atlassian.servicedesk.api.sla.info.SlaInformation;
import com.atlassian.servicedesk.api.sla.info.SlaInformationCompletedCycle;
import com.atlassian.servicedesk.api.sla.info.SlaInformationQuery;
import com.atlassian.servicedesk.api.sla.info.SlaInformationService;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.api.util.paging.PagedResponse;
import com.atlassian.servicedesk.internal.analytics.AbstractProjectAnalyticsEvent;
import com.atlassian.servicedesk.internal.analytics.IssueEventAnalyticsHelper;
import com.atlassian.servicedesk.internal.analytics.SDIssueEventType;
import com.atlassian.servicedesk.internal.api.analytics.AnalyticsEvent;
import com.atlassian.servicedesk.internal.api.analytics.AnalyticsService;
import com.atlassian.servicedesk.internal.api.permission.security.CustomerInvolvedService;
import com.atlassian.servicedesk.internal.api.user.permission.ServiceDeskLicenseAndPermissionService;
import com.atlassian.servicedesk.internal.comment.InternalSDCommentManager;
import com.atlassian.servicedesk.internal.feature.servicedesk.ServiceDeskInternalManager;
import com.atlassian.servicedesk.internal.spi.permission.security.CustomerInvolvedType;
import io.atlassian.fugue.Unit;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IssueEventAnalyticsListener {
    private final CustomerContextService customerContextService;
    private final IssueEventAnalyticsHelper issueEventUtil;
    private final ServiceDeskInternalManager serviceDeskInternalManager;
    private final UserFactory userFactory;
    private final ServiceDeskLicenseAndPermissionService serviceDeskLicenseAndPermissionService;
    private final InternalSDCommentManager internalSDCommentManager;
    private final AnalyticsService analyticsService;
    private final SlaInformationService slaInformationService;
    private final CustomerInvolvedService customerInvolvedService;

    @Autowired
    public IssueEventAnalyticsListener(CustomerContextService customerContextService, IssueEventAnalyticsHelper issueEventUtil, ServiceDeskInternalManager serviceDeskInternalManager, UserFactory userFactory, ServiceDeskLicenseAndPermissionService serviceDeskLicenseAndPermissionService, InternalSDCommentManager internalSDCommentManager, AnalyticsService analyticsService, SlaInformationService slaInformationService, CustomerInvolvedService customerInvolvedService) {
        this.customerContextService = customerContextService;
        this.issueEventUtil = issueEventUtil;
        this.serviceDeskInternalManager = serviceDeskInternalManager;
        this.userFactory = userFactory;
        this.serviceDeskLicenseAndPermissionService = serviceDeskLicenseAndPermissionService;
        this.internalSDCommentManager = internalSDCommentManager;
        this.analyticsService = analyticsService;
        this.slaInformationService = slaInformationService;
        this.customerInvolvedService = customerInvolvedService;
    }

    public void onIssueEvent(IssueEvent issueEvent) {
        if (!this.customerContextService.isInCustomerContext()) {
            Steps.begin(this.issueEventUtil.getEventInitiatior(issueEvent)).then(initiator -> this.issueEventUtil.getProjectOption(issueEvent)).yield((initiator, project) -> {
                this.onIssueEvent(issueEvent, (CheckedUser)initiator, (Project)project);
                return Unit.Unit();
            });
        }
    }

    public void onIssueChangedEvent(IssueChangedEvent issueChangedEvent) {
        Project projectOption = issueChangedEvent.getIssue().getProjectObject();
        Steps.begin(this.issueEventUtil.getEventInitiatior(issueChangedEvent)).then(initiator -> io.atlassian.fugue.Option.option((Object)projectOption)).yield((initiator, project) -> {
            this.onIssueChangedEvent(issueChangedEvent, (CheckedUser)initiator, (Project)project);
            return Unit.Unit();
        });
    }

    public void onCommentCreatedEvent(CommentCreatedEvent commentCreatedEvent) {
        this.onCommentEvent((io.atlassian.fugue.Option<Comment>)io.atlassian.fugue.Option.option((Object)commentCreatedEvent.getComment()));
    }

    public void onCommentUpdatedEvent(CommentUpdatedEvent commentUpdatedEvent) {
        this.onCommentEvent((io.atlassian.fugue.Option<Comment>)io.atlassian.fugue.Option.option((Object)commentUpdatedEvent.getComment()));
    }

    public void onCommentDeletedEvent(CommentDeletedEvent commentDeletedEvent) {
        this.onCommentEvent((io.atlassian.fugue.Option<Comment>)io.atlassian.fugue.Option.option((Object)commentDeletedEvent.getComment()));
    }

    private void onCommentEvent(io.atlassian.fugue.Option<Comment> commentOption) {
        if (!this.customerContextService.isInCustomerContext()) {
            commentOption.foreach(comment -> {
                Project project = comment.getIssue().getProjectObject();
                if (this.serviceDeskInternalManager.isServiceDeskEnabled(project)) {
                    this.onIssueCommented(commentOption);
                }
            });
        }
    }

    private void onIssueChangedEvent(IssueChangedEvent issueChangedEvent, CheckedUser initiator, Project project) {
        if (this.serviceDeskInternalManager.isServiceDeskEnabled(project)) {
            io.atlassian.fugue.Option comment = io.atlassian.fugue.Option.option(issueChangedEvent.getComment().orElse(null));
            this.issueEventUtil.getSDIssueEventTypes(issueChangedEvent).forEach(eventType -> this.onIssueEvent((SDIssueEventType)((Object)eventType), (io.atlassian.fugue.Option<Comment>)comment, initiator, project, issueChangedEvent.getIssue()));
        }
    }

    private void onIssueEvent(IssueEvent issueEvent, CheckedUser eventInitiator, Project project) {
        if (this.serviceDeskInternalManager.isServiceDeskEnabled(project)) {
            this.issueEventUtil.getSDIssueEventTypes(issueEvent).forEach(eventType -> this.onIssueEvent((SDIssueEventType)((Object)eventType), (io.atlassian.fugue.Option<Comment>)io.atlassian.fugue.Option.option((Object)issueEvent.getComment()), eventInitiator, project, issueEvent.getIssue()));
        }
    }

    private void onIssueEvent(SDIssueEventType eventType, io.atlassian.fugue.Option<Comment> comment, CheckedUser eventInitiator, Project project, Issue issue) {
        switch (eventType) {
            case CommentedIssueEventType: {
                this.onIssueCommented(comment);
                break;
            }
            case TransitionedIssueEventType: {
                this.onIssueTransitioned(eventInitiator, project);
                break;
            }
            case AssignedIssueEventType: {
                this.onIssueAssigned(eventInitiator, project);
                break;
            }
            case EditedIssueEventType: {
                this.onIssueEdited(eventInitiator, project);
                break;
            }
            case ResolvedIssueEventType: {
                this.onIssueResolved(eventInitiator, project, issue);
                break;
            }
        }
    }

    private void onIssueCommented(io.atlassian.fugue.Option<Comment> commentOption) {
        if (!this.customerContextService.isInCustomerContext()) {
            Steps.begin(commentOption).then(comment -> io.atlassian.fugue.Option.option((Object)comment.getIssue())).then((comment, issue) -> io.atlassian.fugue.Option.option((Object)comment.getAuthorApplicationUser())).then((comment, issue, commentUser) -> StepsConverters.newerOption((Option)this.userFactory.wrap(commentUser).toOption())).yield((comment, issue, commentUser, user) -> {
                if (this.serviceDeskLicenseAndPermissionService.canViewAgentView((SDUser)user, issue.getProjectObject())) {
                    this.onAgentComment((Comment)comment, issue.getProjectObject());
                } else {
                    this.onCollaboratorComment(issue.getProjectObject());
                }
                return Unit.Unit();
            });
        }
    }

    private void onAgentComment(Comment comment, Project project) {
        if (this.internalSDCommentManager.isCommentInternal(comment)) {
            this.analyticsService.fireAnalyticsEvent((AnalyticsEvent)new AgentPrivateCommentAnalyticsEvent(project.getId()));
        } else {
            this.analyticsService.fireAnalyticsEvent((AnalyticsEvent)new AgentPublicCommentAnalyticsEvent(project.getId()));
        }
    }

    private void onCollaboratorComment(Project project) {
        this.analyticsService.fireAnalyticsEvent((AnalyticsEvent)new CollaboratorCommentAnalyticsEvent(project.getId()));
    }

    private void onIssueTransitioned(CheckedUser user, Project project) {
        if (!this.customerContextService.isInCustomerContext() && this.serviceDeskLicenseAndPermissionService.canViewAgentView((SDUser)user, project)) {
            this.analyticsService.fireAnalyticsEvent((AnalyticsEvent)new AgentStatusTransitionAnalyticsEvent(project.getId()));
        }
    }

    private void onIssueEdited(CheckedUser user, Project project) {
        if (!this.customerContextService.isInCustomerContext() && this.serviceDeskLicenseAndPermissionService.canViewAgentView((SDUser)user, project)) {
            this.analyticsService.fireAnalyticsEvent((AnalyticsEvent)new AgentEditAnalyticsEvent(project.getId()));
        }
    }

    private void onIssueAssigned(CheckedUser user, Project project) {
        if (!this.customerContextService.isInCustomerContext() && this.serviceDeskLicenseAndPermissionService.canViewAgentView((SDUser)user, project)) {
            this.analyticsService.fireAnalyticsEvent((AnalyticsEvent)new AgentAssignAnalyticsEvent(project.getId()));
        }
    }

    private void onIssueResolved(CheckedUser user, Project project, Issue issue) {
        SlaInformationQuery query = this.slaInformationService.newInfoQueryBuilder().issue(issue.getId()).build();
        io.atlassian.fugue.Either slaInformation = StepsConverters.newerEither((Either)this.slaInformationService.getInfo(user.forJIRA(), query));
        slaInformation.foreach(pagedResponse -> {
            boolean isCustomer2 = this.customerInvolvedService.isUserOfType(user, issue, new CustomerInvolvedType[]{CustomerInvolvedType.REPORTER, CustomerInvolvedType.REQUEST_PARTICIPANT, CustomerInvolvedType.CUSTOMER_ORGANISATION});
            if (isCustomer2 || this.serviceDeskLicenseAndPermissionService.canViewAgentView((SDUser)user, project)) {
                this.analyticsService.fireAnalyticsEvent((AnalyticsEvent)new IssueResolvedAnalyticsEvent(project.getId(), issue.getId(), this.getMetSLA((PagedResponse<SlaInformation>)pagedResponse), isCustomer2));
            }
        });
    }

    private String getMetSLA(PagedResponse<SlaInformation> pagedResponse) {
        String metSLA = "NA";
        List slaInformationList = pagedResponse.getResults();
        if (slaInformationList.size() > 0) {
            boolean hasBreachedSLAs = slaInformationList.stream().map(SlaInformation::getCompletedCycles).flatMap(Collection::stream).anyMatch(SlaInformationCompletedCycle::getBreached);
            metSLA = String.valueOf(!hasBreachedSLAs);
        }
        return metSLA;
    }

    @EventName(value="servicedesk.action.issue.resolved")
    private static class IssueResolvedAnalyticsEvent
    extends com.atlassian.servicedesk.internal.analytics.IssueResolvedAnalyticsEvent {
        IssueResolvedAnalyticsEvent(long projectId, long issueId, String metSLA, boolean customerResolved) {
            super(projectId, issueId, metSLA, customerResolved);
        }
    }

    @EventName(value="servicedesk.action.issueview.agent.assign")
    private static class AgentAssignAnalyticsEvent
    extends AbstractProjectAnalyticsEvent {
        AgentAssignAnalyticsEvent(@Nonnull Long projectId) {
            super(projectId);
        }
    }

    @EventName(value="servicedesk.action.issueview.agent.edit")
    private static class AgentEditAnalyticsEvent
    extends AbstractProjectAnalyticsEvent {
        AgentEditAnalyticsEvent(@Nonnull Long projectId) {
            super(projectId);
        }
    }

    @EventName(value="servicedesk.action.issueview.agent.status.transition")
    private static class AgentStatusTransitionAnalyticsEvent
    extends AbstractProjectAnalyticsEvent {
        AgentStatusTransitionAnalyticsEvent(@Nonnull Long projectId) {
            super(projectId);
        }
    }

    @EventName(value="servicedesk.action.issueview.collaborator.comment.private")
    private static class CollaboratorCommentAnalyticsEvent
    extends AbstractProjectAnalyticsEvent {
        CollaboratorCommentAnalyticsEvent(@Nonnull Long projectId) {
            super(projectId);
        }
    }

    @EventName(value="servicedesk.action.issueview.agent.comment.private")
    private static class AgentPrivateCommentAnalyticsEvent
    extends AbstractProjectAnalyticsEvent {
        AgentPrivateCommentAnalyticsEvent(@Nonnull Long projectId) {
            super(projectId);
        }
    }

    @EventName(value="servicedesk.action.issueview.agent.comment.public")
    private static class AgentPublicCommentAnalyticsEvent
    extends AbstractProjectAnalyticsEvent {
        AgentPublicCommentAnalyticsEvent(@Nonnull Long projectId) {
            super(projectId);
        }
    }
}

