/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.analytics;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.servicedesk.internal.api.analytics.AnalyticsEvent;
import com.atlassian.servicedesk.internal.api.analytics.AnalyticsService;
import com.atlassian.servicedesk.internal.api.util.ServiceDeskApplicationVersionUtil;
import io.atlassian.fugue.Option;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class AnalyticsServiceImpl
implements AnalyticsService {
    private final WebResourceIntegration webResourceIntegration;
    private final ServiceDeskApplicationVersionUtil serviceDeskApplicationVersionUtil;
    private final EventPublisher eventPublisher;

    @Autowired
    public AnalyticsServiceImpl(WebResourceIntegration webResourceIntegration, ServiceDeskApplicationVersionUtil serviceDeskApplicationVersionUtil, EventPublisher eventPublisher) {
        this.webResourceIntegration = webResourceIntegration;
        this.serviceDeskApplicationVersionUtil = serviceDeskApplicationVersionUtil;
        this.eventPublisher = eventPublisher;
    }

    public boolean isAtlassianAnalyticsInstalled() {
        String moduleCompleteKey = "com.atlassian.analytics.analytics-client:js-events";
        return Option.option((Object)this.webResourceIntegration.getPluginAccessor().getEnabledPluginModule(moduleCompleteKey)).isDefined();
    }

    public void fireAnalyticsEvent(AnalyticsEvent event) {
        event.setSdVersion(this.serviceDeskApplicationVersionUtil.getServiceDeskApplicationVersion());
        this.eventPublisher.publish((Object)event);
    }
}

