/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.admin;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.FeatureFlag;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.servicedesk.internal.api.featureflag.ServiceDeskFeatureFlags;
import io.atlassian.fugue.Option;

public enum EmailTrimmingMode {
    CUSTOM(new FeatureFlagDependant(ServiceDeskFeatureFlags.CUSTOM_EMAIL_STRIPPING_RULES, "sd.admin.incoming.email.trimming.custom.title", "sd.admin.incoming.email.trimming.custom.description")),
    SMART("sd.admin.incoming.email.trimming.smart.title", "sd.admin.incoming.email.trimming.smart.simple.description", (Option<FeatureFlagDependant>)Option.some((Object)new FeatureFlagDependant(ServiceDeskFeatureFlags.CUSTOM_EMAIL_STRIPPING_RULES, "sd.admin.incoming.email.trimming.smart.basic.title", "sd.admin.incoming.email.trimming.smart.basic.description"))),
    NONE("sd.admin.incoming.email.trimming.none.title", "sd.admin.incoming.email.trimming.none.description", (Option<FeatureFlagDependant>)Option.none());

    private final Option<String> i18nNameKey;
    private final Option<String> i18nDescriptionKey;
    private final Option<FeatureFlagDependant> featureFlagDependant;
    private final boolean hasFallbackIfFeatureNotDefinedOrEnabled;

    private EmailTrimmingMode(FeatureFlagDependant featureFlagDependant) {
        this.featureFlagDependant = Option.some((Object)featureFlagDependant);
        this.i18nNameKey = Option.none();
        this.i18nDescriptionKey = Option.none();
        this.hasFallbackIfFeatureNotDefinedOrEnabled = false;
    }

    private EmailTrimmingMode(String i18nNameKey, String i18nDescriptionKey, Option<FeatureFlagDependant> featureFlagDependantOption) {
        this.featureFlagDependant = featureFlagDependantOption;
        this.i18nNameKey = Option.some((Object)i18nNameKey);
        this.i18nDescriptionKey = Option.some((Object)i18nDescriptionKey);
        this.hasFallbackIfFeatureNotDefinedOrEnabled = true;
    }

    public String getI18nNameKey() {
        return (String)this.featureFlagDependant.filter(dependant -> this.isFeatureEnabled(dependant.getFeatureFlag())).map(FeatureFlagDependant::getI18nNameKey).orElse(() -> this.i18nNameKey).getOrThrow(() -> new IllegalStateException("No i18n key exists for name of EmailTrimmingMode " + this.name()));
    }

    public String getI18nDescriptionKey() {
        return (String)this.featureFlagDependant.filter(dependant -> this.isFeatureEnabled(dependant.getFeatureFlag())).map(FeatureFlagDependant::getI18nDescriptionKey).orElse(() -> this.i18nDescriptionKey).getOrThrow(() -> new IllegalStateException("No i18n key exists for description of EmailTrimmingMode " + this.name()));
    }

    public boolean isModeAvailable() {
        return (Boolean)this.featureFlagDependant.filter(dependant -> this.isFeatureEnabled(dependant.getFeatureFlag())).fold(() -> this.hasFallbackIfFeatureNotDefinedOrEnabled, dependant -> true);
    }

    private boolean isFeatureEnabled(FeatureFlag featureFlag) {
        return ((FeatureManager)ComponentAccessor.getComponent(FeatureManager.class)).isEnabled(featureFlag);
    }

    private static class FeatureFlagDependant {
        private final FeatureFlag featureFlag;
        private final String i18nNameKey;
        private final String i18nDescriptionKey;

        private FeatureFlagDependant(FeatureFlag featureFlag, String i18nNameKey, String i18nDescriptionKey) {
            this.featureFlag = featureFlag;
            this.i18nNameKey = i18nNameKey;
            this.i18nDescriptionKey = i18nDescriptionKey;
        }

        FeatureFlag getFeatureFlag() {
            return this.featureFlag;
        }

        String getI18nNameKey() {
            return this.i18nNameKey;
        }

        String getI18nDescriptionKey() {
            return this.i18nDescriptionKey;
        }
    }
}

