/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.admin;

import com.atlassian.annotations.nonnull.ReturnValuesAreNullableByDefault;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.api.persistence.GlobalPropertyDao;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.internal.admin.EmailCreateCustomerMode;
import com.atlassian.servicedesk.internal.admin.EmailRequestsSettingsManager;
import com.atlassian.servicedesk.internal.admin.EmailTrimmingMode;
import com.google.common.annotations.VisibleForTesting;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Functions;
import io.atlassian.fugue.Option;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ParametersAreNonnullByDefault
@ReturnValuesAreNullableByDefault
@Component
public class EmailRequestsSettingsManagerImpl
implements EmailRequestsSettingsManager {
    private static final Logger log = LoggerFactory.getLogger(EmailRequestsSettingsManagerImpl.class);
    @VisibleForTesting
    static final String OUTSIDER_COMMENTS_PROPERTY_KEY = "com.atlassian.servicedesk.admin.email.outsider.comments.enabled";
    @VisibleForTesting
    static final String FORMATTING_PROPERTY_KEY = "com.atlassian.servicedesk.admin.email.formatting.enabled";
    @VisibleForTesting
    static final String TRIMMING_PROPERTY_KEY = "com.atlassian.servicedesk.admin.email.trimming.mode";
    @VisibleForTesting
    static final String CREATE_CUSTOMER_PROPERTY_KEY = "com.atlassian.servicedesk.admin.email.create.customer.mode";
    private static final String CREATE_CUSTOMER_ALWAYS_AGENT = "alwaysAgent";
    private static final String CREATE_CUSTOMER_ANYONE_PUBLIC_SIGNUP = "anyonePublicSignup";
    private final GlobalPropertyDao globalPropertyDao;
    private final ErrorResultHelper errorResultHelper;

    @Autowired
    public EmailRequestsSettingsManagerImpl(GlobalPropertyDao globalPropertyDao, ErrorResultHelper errorResultHelper) {
        this.globalPropertyDao = globalPropertyDao;
        this.errorResultHelper = errorResultHelper;
    }

    @Override
    public Either<AnError, Boolean> setOutsiderCommentsEnabled(boolean enabled) {
        this.globalPropertyDao.setBooleanProperty(OUTSIDER_COMMENTS_PROPERTY_KEY, Boolean.valueOf(enabled));
        boolean actualEnabled = this.getOutsiderCommentsEnabled();
        if (actualEnabled == enabled) {
            return Either.right((Object)actualEnabled);
        }
        return Either.left((Object)this.errorResultHelper.internalServiceError500("sd.admin.incoming.email.outsider.comments.update.failed", new Object[0]).build());
    }

    @Override
    public boolean getOutsiderCommentsEnabled() {
        Boolean enabled = this.globalPropertyDao.getBooleanProperty(OUTSIDER_COMMENTS_PROPERTY_KEY);
        return (Boolean)Option.option((Object)enabled).getOrElse((Object)true);
    }

    @Override
    public Either<AnError, Boolean> setFormattingEnabled(boolean enabled) {
        this.globalPropertyDao.setBooleanProperty(FORMATTING_PROPERTY_KEY, Boolean.valueOf(enabled));
        boolean actualEnabled = this.getFormattingEnabled();
        if (actualEnabled == enabled) {
            return Either.right((Object)actualEnabled);
        }
        return Either.left((Object)this.errorResultHelper.internalServiceError500("sd.admin.incoming.email.formatting.update.failed", new Object[0]).build());
    }

    @Override
    public boolean getFormattingEnabled() {
        Boolean formattingEnabled = this.globalPropertyDao.getBooleanProperty(FORMATTING_PROPERTY_KEY);
        return (Boolean)Option.option((Object)formattingEnabled).getOrElse((Object)true);
    }

    @Override
    public Either<AnError, EmailTrimmingMode> setTrimmingMode(EmailTrimmingMode emailTrimmingMode) {
        this.globalPropertyDao.setTextProperty(TRIMMING_PROPERTY_KEY, emailTrimmingMode.name());
        EmailTrimmingMode actualTrimmingMode = this.getTrimmingMode();
        if (emailTrimmingMode == actualTrimmingMode) {
            return Either.right((Object)((Object)actualTrimmingMode));
        }
        return Either.left((Object)this.errorResultHelper.internalServiceError500("sd.admin.incoming.email.trimming.update.failed", new Object[0]).build());
    }

    @Override
    public EmailTrimmingMode getTrimmingMode() {
        String savedTrimmingMode = this.globalPropertyDao.getTextProperty(TRIMMING_PROPERTY_KEY);
        EmailTrimmingMode result = DEFAULT_TRIMMING_MODE;
        if (savedTrimmingMode != null) {
            try {
                result = EmailTrimmingMode.valueOf(savedTrimmingMode);
                if (!result.isModeAvailable()) {
                    log.warn("Invalid global property '{}' in database: {} as that mode is invalid for EmailTrimmingMode, using {}", new Object[]{TRIMMING_PROPERTY_KEY, savedTrimmingMode, DEFAULT_TRIMMING_MODE});
                    result = DEFAULT_TRIMMING_MODE;
                }
            }
            catch (IllegalArgumentException ex) {
                log.error("Invalid global property '{}' in database: {}", (Object)TRIMMING_PROPERTY_KEY, (Object)savedTrimmingMode);
            }
        }
        return result;
    }

    @Override
    public Either<AnError, EmailCreateCustomerMode> setEmailCreateCustomerMode(@Nonnull EmailCreateCustomerMode emailCreateCustomerMode) {
        String createCustomerModeJson;
        try {
            createCustomerModeJson = new JSONObject().put(CREATE_CUSTOMER_ALWAYS_AGENT, emailCreateCustomerMode.isCanAgentCreateAlways()).put(CREATE_CUSTOMER_ANYONE_PUBLIC_SIGNUP, emailCreateCustomerMode.isCanAnyoneCreateWithPublicSignup()).toString();
        }
        catch (JSONException e) {
            log.warn("Failed to save com.atlassian.servicedesk.admin.email.create.customer.mode due to JSON exception", (Throwable)e);
            return Either.left((Object)this.errorResultHelper.internalServiceError500("sd.admin.incoming.email.create.customer.mode.update.failed", new Object[0]).build());
        }
        this.globalPropertyDao.setTextProperty(CREATE_CUSTOMER_PROPERTY_KEY, createCustomerModeJson);
        EmailCreateCustomerMode actualEmailCreateCustomerMode = this.getEmailCreateCustomerMode();
        if (actualEmailCreateCustomerMode == emailCreateCustomerMode) {
            return Either.right((Object)((Object)actualEmailCreateCustomerMode));
        }
        return Either.left((Object)this.errorResultHelper.internalServiceError500("sd.admin.incoming.email.create.customer.mode.update.failed", new Object[0]).build());
    }

    @Override
    public EmailCreateCustomerMode getEmailCreateCustomerMode() {
        return (EmailCreateCustomerMode)((Object)Option.option((Object)this.globalPropertyDao.getTextProperty(CREATE_CUSTOMER_PROPERTY_KEY)).map(textProperty -> {
            EmailCreateCustomerMode emailCreateCustomerMode;
            try {
                JSONObject createCustomerModeJson = new JSONObject(textProperty);
                emailCreateCustomerMode = (EmailCreateCustomerMode)((Object)((Object)Steps.begin(this.extractBooleanFromJsonObject(createCustomerModeJson, CREATE_CUSTOMER_ALWAYS_AGENT)).then(() -> this.extractBooleanFromJsonObject(createCustomerModeJson, CREATE_CUSTOMER_ANYONE_PUBLIC_SIGNUP)).yield(EmailCreateCustomerMode::findEmailCreateCustomerMode).getOr(() -> {
                    log.warn("Invalid or incomplete json found for com.atlassian.servicedesk.admin.email.create.customer.mode property, will use default " + (Object)((Object)DEFAULT_CREATE_CUSTOMER_MODE));
                    return DEFAULT_CREATE_CUSTOMER_MODE;
                })));
            }
            catch (JSONException e) {
                log.warn("There was a problem while reading or parsing the com.atlassian.servicedesk.admin.email.create.customer.mode so will use default " + (Object)((Object)DEFAULT_CREATE_CUSTOMER_MODE), (Throwable)e);
                emailCreateCustomerMode = DEFAULT_CREATE_CUSTOMER_MODE;
            }
            return emailCreateCustomerMode;
        }).getOr(() -> DEFAULT_CREATE_CUSTOMER_MODE));
    }

    private Option<Boolean> extractBooleanFromJsonObject(JSONObject jsonObject, String key) {
        return Option.option((Object)jsonObject.opt(key)).flatMap(Functions.isInstanceOf(Boolean.class));
    }
}

