/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.bootstrap.upgrade.tasks;

import com.atlassian.annotations.tenancy.TenancyScope;
import com.atlassian.annotations.tenancy.TenantAware;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.icon.IconType;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.servicedesk.bootstrap.upgrade.helper.AsyncUpgradeTaskMigrateRequestTypeIconIDsDAO;
import com.atlassian.servicedesk.bootstrap.upgrade.helper.RequestTypeDO;
import com.atlassian.servicedesk.bootstrap.upgrade.helper.VariableFrequencyProgressLogger;
import com.atlassian.servicedesk.internal.api.bootstrap.upgrade.SyncUpgradeTask;
import com.atlassian.servicedesk.internal.api.requesttype.icons.RequestTypeSystemIcon;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.icon.RequestTypeIconDefinition;
import com.mysema.commons.lang.CloseableIterator;
import io.atlassian.fugue.Unit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.apache.commons.lang.time.StopWatch;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class SyncUpgradeTaskMigrateRequestTypeIconIDs
implements SyncUpgradeTask {
    private static final Logger log = Logger.getLogger(SyncUpgradeTaskMigrateRequestTypeIconIDs.class);
    private final DatabaseAccessor databaseAccessor;
    private final AsyncUpgradeTaskMigrateRequestTypeIconIDsDAO dao;
    private RequestTypeSystemIconsCreator requestTypeSystemIconsCreator;
    private final AvatarManager avatarManager;
    private static final Function<Long, String> LOG_MESSAGE_BUILDER = upgradedRequestTypes -> upgradedRequestTypes + " requestTypes successfully upgraded by " + SyncUpgradeTaskMigrateRequestTypeIconIDs.class.getSimpleName();

    @Autowired
    public SyncUpgradeTaskMigrateRequestTypeIconIDs(DatabaseAccessor databaseAccessor, AsyncUpgradeTaskMigrateRequestTypeIconIDsDAO dao, AvatarManager avatarManager) {
        this.databaseAccessor = databaseAccessor;
        this.dao = dao;
        this.avatarManager = avatarManager;
        this.requestTypeSystemIconsCreator = new RequestTypeSystemIconsCreator(avatarManager);
    }

    public String getVersionIntroduced() {
        return "3.1.0-OD-13";
    }

    public String getVersionMigratedFromAsync() {
        return "3.2.0-OD-08";
    }

    public void doUpgrade() {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        VariableFrequencyProgressLogger.VariableFrequencyProgressLoggerBuilder builder = new VariableFrequencyProgressLogger.VariableFrequencyProgressLoggerBuilder(log, LOG_MESSAGE_BUILDER::apply);
        VariableFrequencyProgressLogger progressLogger = builder.withLogFrequencyRange(0L, 100L).withLogFrequencyRange(1000L, 1000L).build();
        this.requestTypeSystemIconsCreator.initialize();
        Long defaultIconID = this.avatarManager.getDefaultAvatarId(RequestTypeIconDefinition.ICON_TYPE);
        if (defaultIconID == null || defaultIconID <= 0L) {
            log.error((Object)"Unable to start up as there is no default icon ID for SD_REQTYPE");
            throw new RuntimeException("Unable to start up as there is no default icon ID for SD_REQTYPE");
        }
        this.databaseAccessor.runInTransaction(databaseConnection -> {
            ArrayList<RequestTypeDO> reqTypeTobeUpdated = new ArrayList<RequestTypeDO>();
            try (CloseableIterator<RequestTypeDO> rows = this.dao.selectRows((DatabaseConnection)databaseConnection);){
                while (rows.hasNext()) {
                    RequestTypeDO requestType = (RequestTypeDO)rows.next();
                    if (requestType.getOldIconId() != null && requestType.getNewIconId() == null) {
                        Long newIconID = this.requestTypeSystemIconsCreator.mapOldIdToNewId((long)requestType.getOldIconId());
                        if (newIconID == null) {
                            log.warn((Object)("Unable to map old icon ID " + requestType.getOldIconId() + " to a value. Using the default icon ID of " + defaultIconID));
                            newIconID = defaultIconID;
                        }
                        requestType.setNewIconId(newIconID);
                        reqTypeTobeUpdated.add(requestType);
                    }
                    progressLogger.onUpgradeProgress();
                }
            }
            for (RequestTypeDO rt : reqTypeTobeUpdated) {
                this.dao.updateRow((DatabaseConnection)databaseConnection, rt);
            }
            return Unit.Unit();
        });
        stopWatch.stop();
        long taskDuration = TimeUnit.SECONDS.convert(stopWatch.getTime(), TimeUnit.MILLISECONDS);
        log.info((Object)this.buildSuccessMessage(taskDuration));
    }

    public String getAsyncTaskName() {
        return "AsyncUpgradeTaskMigrateRequestTypeIconIDs";
    }

    private String buildSuccessMessage(long timeTakenSeconds) {
        return "Successfully completed " + this.getClass().getSimpleName() + " after " + timeTakenSeconds + " seconds.";
    }

    public void setRequestTypeSystemIconsCreator(RequestTypeSystemIconsCreator creator) {
        this.requestTypeSystemIconsCreator = creator;
    }

    public class RequestTypeSystemIconsCreator {
        private Logger LOG = Logger.getLogger(RequestTypeSystemIconsCreator.class);
        private final AvatarManager avatarManager;
        @TenantAware(value=TenancyScope.TENANTED)
        private Map<Long, Long> oldIdToNewIdMap;
        @TenantAware(value=TenancyScope.TENANTED)
        private Map<RequestTypeSystemIcon, Long> iconIdToNewIdMap;
        private final ExistingSystemIcon[] existingSystemIcons = new ExistingSystemIcon[]{new ExistingSystemIcon(RequestTypeSystemIcon.ICON_PLUS, "RT_ICONS_plus.svg", 0L), new ExistingSystemIcon(RequestTypeSystemIcon.ICON_PRESENT, "RT_ICONS_present.svg", 1L), new ExistingSystemIcon(RequestTypeSystemIcon.ICON_CALENDAR, "RT_ICONS_calendar.svg", 2L), new ExistingSystemIcon(RequestTypeSystemIcon.ICON_OPEN_BOOK, "RT_ICONS_open_book.svg", 3L), new ExistingSystemIcon(RequestTypeSystemIcon.ICON_TWO_PEOPLE, "RT_ICONS_two_people.svg", 4L), new ExistingSystemIcon(RequestTypeSystemIcon.ICON_CAMERA, "RT_ICONS_camera.svg", 5L), new ExistingSystemIcon(RequestTypeSystemIcon.ICON_HEART, "RT_ICONS_heart.svg", 6L), new ExistingSystemIcon(RequestTypeSystemIcon.ICON_LIGHT_BULB, "RT_ICONS_light_bulb.svg", 7L), new ExistingSystemIcon(RequestTypeSystemIcon.ICON_HOUSE, "RT_ICONS_house.svg", 8L), new ExistingSystemIcon(RequestTypeSystemIcon.ICON_CHAIR, "RT_ICONS_chair.svg", 9L), new ExistingSystemIcon(RequestTypeSystemIcon.ICON_ROBOT, "RT_ICONS_robot.svg", 10L), new ExistingSystemIcon(RequestTypeSystemIcon.ICON_SWIPE_CARD, "RT_ICONS_swipe_card.svg", 11L), new ExistingSystemIcon(RequestTypeSystemIcon.ICON_DOLLAR, "RT_ICONS_dollar.svg", 12L), new ExistingSystemIcon(RequestTypeSystemIcon.ICON_MARKER, "RT_ICONS_marker.svg", 13L), new ExistingSystemIcon(RequestTypeSystemIcon.ICON_CAR, "RT_ICONS_car.svg", 14L), new ExistingSystemIcon(RequestTypeSystemIcon.ICON_AEROPLANE, "RT_ICONS_aeroplane.svg", 15L), new ExistingSystemIcon(RequestTypeSystemIcon.ICON_DATABASE, "RT_ICONS_database.svg", 16L), new ExistingSystemIcon(RequestTypeSystemIcon.ICON_VOLUME, "RT_ICONS_volume.svg", 17L), new ExistingSystemIcon(RequestTypeSystemIcon.ICON_SMARTPHONE, "RT_ICONS_smartphone.svg", 18L), new ExistingSystemIcon(RequestTypeSystemIcon.ICON_KEYBOARD, "RT_ICONS_keyboard.svg", 19L), new ExistingSystemIcon(RequestTypeSystemIcon.ICON_CODE, "RT_ICONS_code.svg", 20L), new ExistingSystemIcon(RequestTypeSystemIcon.ICON_WORKFLOW, "RT_ICONS_workflow.svg", 21L), new ExistingSystemIcon(RequestTypeSystemIcon.ICON_UP_CLOUD, "RT_ICONS_up_cloud.svg", 22L), new ExistingSystemIcon(RequestTypeSystemIcon.ICON_POWER_BUTTON, "RT_ICONS_power_button.svg", 23L), new ExistingSystemIcon(RequestTypeSystemIcon.ICON_HEADSET, "RT_ICONS_headset.svg", 24L), new ExistingSystemIcon(RequestTypeSystemIcon.ICON_GEARS, "RT_ICONS_gears.svg", 25L), new ExistingSystemIcon(RequestTypeSystemIcon.ICON_LOOP, "RT_ICONS_loop.svg", 26L), new ExistingSystemIcon(RequestTypeSystemIcon.ICON_QUESTION, "RT_ICONS_question.svg", 27L), new ExistingSystemIcon(RequestTypeSystemIcon.ICON_SIGNAL_TOWER, "RT_ICONS_signal_tower.svg", 28L), new ExistingSystemIcon(RequestTypeSystemIcon.ICON_DOWN_CLOUD, "RT_ICONS_down_cloud.svg", 29L), new ExistingSystemIcon(RequestTypeSystemIcon.ICON_WRENCH, "RT_ICONS_wrench.svg", 30L), new ExistingSystemIcon(RequestTypeSystemIcon.ICON_ADD_PERSON, "RT_ICONS_add_person.svg", 31L), new ExistingSystemIcon(RequestTypeSystemIcon.ICON_MONITOR, "RT_ICONS_monitor.svg", 32L), new ExistingSystemIcon(RequestTypeSystemIcon.ICON_ENVELOPE, "RT_ICONS_envelope.svg", 33L), new ExistingSystemIcon(RequestTypeSystemIcon.ICON_PADLOCK, "RT_ICONS_padlock.svg", 34L), new ExistingSystemIcon(RequestTypeSystemIcon.ICON_PRINTER, "RT_ICONS_printer.svg", 35L), new ExistingSystemIcon(RequestTypeSystemIcon.ICON_SHARE, "RT_ICONS_share.svg", 36L), new ExistingSystemIcon(RequestTypeSystemIcon.ICON_CD, "RT_ICONS_cd.svg", 37L), new ExistingSystemIcon(RequestTypeSystemIcon.ICON_WARNING, "RT_ICONS_warning.svg", 38L), new ExistingSystemIcon(RequestTypeSystemIcon.ICON_THUNDER, "RT_ICONS_thunder.svg", 39L)};

        public RequestTypeSystemIconsCreator(AvatarManager avatarManager) {
            this.avatarManager = avatarManager;
            this.oldIdToNewIdMap = new HashMap<Long, Long>();
            this.iconIdToNewIdMap = new HashMap<RequestTypeSystemIcon, Long>();
        }

        public void initialize() {
            List currentIcons = this.avatarManager.getAllSystemAvatars(IconType.of((String)"SD_REQTYPE"));
            List<ExistingSystemIcon> filenamesWithIDs = Arrays.asList(this.existingSystemIcons);
            for (ExistingSystemIcon element : filenamesWithIDs) {
                element.setId(null);
            }
            for (Avatar currentIcon : currentIcons) {
                ExistingSystemIcon check = new ExistingSystemIcon(null, currentIcon.getFileName(), null);
                if (!filenamesWithIDs.contains(check)) continue;
                int location = filenamesWithIDs.indexOf(check);
                ExistingSystemIcon existing = filenamesWithIDs.get(location);
                existing.setId(currentIcon.getId());
                this.LOG.info((Object)("Icon (old ID=" + existing.getOldID() + ") with filename " + existing.getFilename() + " already exists. ID=" + currentIcon.getId()));
                this.oldIdToNewIdMap.put(existing.getOldID(), currentIcon.getId());
                this.iconIdToNewIdMap.put(existing.getIcon(), currentIcon.getId());
            }
            for (ExistingSystemIcon iconToCreate : filenamesWithIDs) {
                if (iconToCreate.getNewId() != null) continue;
                InternalIcon newIcon = new InternalIcon(iconToCreate.getFilename());
                Avatar created = this.avatarManager.create((Avatar)newIcon);
                iconToCreate.setId(created.getId());
                this.LOG.info((Object)("Icon (old ID=" + iconToCreate.getOldID() + ") with filename " + iconToCreate.getFilename() + " did not exist. Created with ID=" + created.getId()));
                this.oldIdToNewIdMap.put(iconToCreate.getOldID(), created.getId());
                this.iconIdToNewIdMap.put(iconToCreate.getIcon(), created.getId());
            }
        }

        public Long mapOldIdToNewId(Long oldId) {
            return this.oldIdToNewIdMap.get(oldId);
        }

        class ExistingSystemIcon {
            private RequestTypeSystemIcon icon;
            private String filename;
            private Long oldID;
            private Long id;

            public ExistingSystemIcon(RequestTypeSystemIcon icon, String filename, Long oldID) {
                this.icon = icon;
                this.filename = filename;
                this.oldID = oldID;
            }

            public String getFilename() {
                return this.filename;
            }

            public Long getOldID() {
                return this.oldID;
            }

            public Long getNewId() {
                return this.id;
            }

            public RequestTypeSystemIcon getIcon() {
                return this.icon;
            }

            void setId(Long value) {
                this.id = value;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof ExistingSystemIcon)) {
                    return false;
                }
                ExistingSystemIcon that = (ExistingSystemIcon)o;
                return Objects.equals(this.filename, that.filename);
            }

            public int hashCode() {
                return Objects.hash(this.filename);
            }
        }

        class InternalIcon
        implements Avatar {
            private String filename;

            public InternalIcon(String filename) {
                this.filename = filename;
            }

            @Nonnull
            public Avatar.Type getAvatarType() {
                return Avatar.Type.OTHER;
            }

            @Nonnull
            public IconType getIconType() {
                return IconType.of((String)"SD_REQTYPE");
            }

            @Nonnull
            public String getFileName() {
                return this.filename;
            }

            @Nonnull
            public String getContentType() {
                return "image/svg+xml";
            }

            public Long getId() {
                return null;
            }

            public String getOwner() {
                return null;
            }

            public boolean isSystemAvatar() {
                return true;
            }
        }
    }
}

