/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.bootstrap.upgrade.tasks;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.pocketknife.api.persistence.GlobalPropertyDao;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.pocketknife.api.querydsl.stream.CloseableIterable;
import com.atlassian.pocketknife.api.querydsl.stream.StreamingQueryFactory;
import com.atlassian.pocketknife.internal.logging.LoggingUtil;
import com.atlassian.servicedesk.internal.ao.schema.current.ServiceDeskDbSchema;
import com.atlassian.servicedesk.internal.api.bootstrap.upgrade.SyncUpgradeTask;
import com.atlassian.servicedesk.internal.querydsl.mapping.Tables;
import com.google.common.annotations.VisibleForTesting;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.sql.SQLQuery;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Unit;
import java.sql.Timestamp;
import java.util.EnumSet;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.time.StopWatch;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncUpgradeTaskMigrateDateColumnsForTimeMetrics
implements SyncUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(SyncUpgradeTaskMigrateDateColumnsForTimeMetrics.class);
    private static final String TASK_FIRST_INITIALISED_TIME = "TASK_FIRST_INITIALISED_TIME_AsyncUpgradeTaskMigrateDateColumnsForTimeMetrics";
    private final DatabaseAccessor databaseAccessor;
    private final StreamingQueryFactory streamingQueryFactory;
    private final ActiveObjects ao;
    private final GlobalPropertyDao globalPropertyDao;

    public SyncUpgradeTaskMigrateDateColumnsForTimeMetrics(DatabaseAccessor databaseAccessor, ActiveObjects ao, StreamingQueryFactory streamingQueryFactory, GlobalPropertyDao globalPropertyDao) {
        this.databaseAccessor = databaseAccessor;
        this.ao = ao;
        this.streamingQueryFactory = streamingQueryFactory;
        this.globalPropertyDao = globalPropertyDao;
        LoggingUtil.setLevelToInfoIfNotDefined(log);
    }

    public String getVersionIntroduced() {
        return "3.1.0-OD-07";
    }

    private String buildSuccessMessage(long timeTakenSeconds) {
        return "Successfully completed " + this.getClass().getSimpleName() + " after " + timeTakenSeconds + " seconds.";
    }

    public void doUpgrade() {
        long upgradeStartTime = this.getUpgradeStartTime();
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        this.migrateEachMetricColumnTypeToEpoch(upgradeStartTime);
        this.migrateGoalColumnToEpoch();
        stopWatch.stop();
        long taskDuration = TimeUnit.SECONDS.convert(stopWatch.getTime(), TimeUnit.MILLISECONDS);
        log.info(this.buildSuccessMessage(taskDuration));
    }

    @VisibleForTesting
    long getUpgradeStartTime() {
        return (Long)Option.option((Object)this.globalPropertyDao.getLongProperty(TASK_FIRST_INITIALISED_TIME)).getOr(() -> {
            long value = DateTime.now().getMillis();
            this.globalPropertyDao.setLongProperty(TASK_FIRST_INITIALISED_TIME, Long.valueOf(value));
            return value;
        });
    }

    @VisibleForTesting
    void migrateEachMetricColumnTypeToEpoch(long upgradeStartTime) {
        for (MetricColumnType metricColumnType : EnumSet.allOf(MetricColumnType.class)) {
            log.info("Now processing time metric data migration for {}", (Object)metricColumnType);
            this.databaseAccessor.runInTransaction(conn -> {
                try (CloseableIterable<Tuple> timeMetricIterator = this.streamTimeMetricsForUpgradeTask((DatabaseConnection)conn, metricColumnType, upgradeStartTime);){
                    for (Tuple timeMetricTuple : timeMetricIterator) {
                        this.setTimeMetricChangeMsEpochs(timeMetricTuple, metricColumnType);
                    }
                }
                return Unit.Unit();
            });
            log.info("Finished processing time metric data migration for column {}", (Object)metricColumnType);
        }
    }

    @VisibleForTesting
    void migrateGoalColumnToEpoch() {
        log.info("Now processing goal data migration");
        this.databaseAccessor.runInTransaction(conn -> {
            try (CloseableIterable<Tuple> goalIterator = this.streamGoalsForUpgradeTask((DatabaseConnection)conn);){
                for (Tuple goalTuple : goalIterator) {
                    this.setGoalUpdateMsEpochs(goalTuple);
                }
            }
            return Unit.Unit();
        });
        log.info("Finished processing goal data migration");
    }

    public String getVersionMigratedFromAsync() {
        return "3.3.0";
    }

    public String getAsyncTaskName() {
        return "AsyncUpgradeTaskMigrateDateColumnsForTimeMetrics";
    }

    private CloseableIterable<Tuple> streamTimeMetricsForUpgradeTask(DatabaseConnection conn, MetricColumnType metricColumnType, long upgradeStartTime) {
        NumberPath<Long> path;
        switch (metricColumnType) {
            case DEFINITION_CHANGE: {
                path = Tables.TIME_METRIC.DEFINITION_CHANGE_MS_EPOCH;
                break;
            }
            case GOALS_CHANGE: {
                path = Tables.TIME_METRIC.GOALS_CHANGE_MS_EPOCH;
                break;
            }
            case THRESHOLDS_CHANGE: {
                path = Tables.TIME_METRIC.THRESHOLDS_CHANGE_MS_EPOCH;
                break;
            }
            default: {
                throw new RuntimeException("Invalid type : " + (Object)((Object)metricColumnType));
            }
        }
        return this.streamingQueryFactory.stream(conn, () -> (SQLQuery)((SQLQuery)conn.select((Expression[])new Path[]{Tables.TIME_METRIC.ID}).from((Expression)Tables.TIME_METRIC)).where((Predicate)path.isNull().or((Predicate)path.loe((Number)0L).and((Predicate)Tables.TIME_METRIC.CREATED_DATE.isNull().or((Predicate)Tables.TIME_METRIC.CREATED_DATE.loe((Number)upgradeStartTime))))));
    }

    private CloseableIterable<Tuple> streamGoalsForUpgradeTask(DatabaseConnection conn) {
        return this.streamingQueryFactory.stream(conn, () -> (SQLQuery)((SQLQuery)conn.select((Expression[])new Path[]{Tables.GOAL.ID}).from((Expression)Tables.GOAL)).where((Predicate)Tables.GOAL.TIME_UPDATED_MS_EPOCH.isNull().or((Predicate)Tables.GOAL.TIME_UPDATED_MS_EPOCH.loe((Number)0L))));
    }

    private void setTimeMetricChangeMsEpochs(Tuple timeMetricTuple, MetricColumnType metricColumnType) {
        ServiceDeskDbSchema.TimeMetricAO timeMetricAO = (ServiceDeskDbSchema.TimeMetricAO)this.ao.get(ServiceDeskDbSchema.TimeMetricAO.class, timeMetricTuple.get(Tables.TIME_METRIC.ID));
        switch (metricColumnType) {
            case DEFINITION_CHANGE: {
                Long definitionChangeMsEpoch = this.covertTimestampToMsEpoch(timeMetricAO.getDefinitionChangeDate());
                timeMetricAO.setDefinitionChangeMsEpoch(definitionChangeMsEpoch);
                break;
            }
            case GOALS_CHANGE: {
                Long goalsChangeMsEpoch = this.covertTimestampToMsEpoch(timeMetricAO.getGoalsChangeDate());
                timeMetricAO.setGoalsChangeMsEpoch(goalsChangeMsEpoch);
                break;
            }
            case THRESHOLDS_CHANGE: {
                Long thresholdsConfigChangeMsEpoch = this.covertTimestampToMsEpoch(timeMetricAO.getThresholdsConfigChangeDate());
                timeMetricAO.setThresholdsChangeMsEpoch(thresholdsConfigChangeMsEpoch);
            }
        }
        timeMetricAO.save();
    }

    private void setGoalUpdateMsEpochs(Tuple goalTuple) {
        ServiceDeskDbSchema.GoalAO goalAO = (ServiceDeskDbSchema.GoalAO)this.ao.get(ServiceDeskDbSchema.GoalAO.class, goalTuple.get(Tables.GOAL.ID));
        Long timeUpdatedMsEpoch = this.covertTimestampToMsEpoch(goalAO.getTimeUpdatedDate());
        goalAO.setTimeUpdatedMsEpoch(timeUpdatedMsEpoch);
        goalAO.save();
    }

    private Long covertTimestampToMsEpoch(Timestamp timestamp) {
        return (Long)Option.option((Object)timestamp).map(ts -> new DateTime(ts).getMillis()).getOrNull();
    }

    private static enum MetricColumnType {
        DEFINITION_CHANGE,
        GOALS_CHANGE,
        THRESHOLDS_CHANGE;

    }
}

