/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.bootstrap.upgrade.tasks;

import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.scheme.SchemeEntity;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.servicedesk.bootstrap.upgrade.helper.MigrateAgentPermissionHelper;
import com.atlassian.servicedesk.internal.api.bootstrap.upgrade.SyncUpgradeTask;
import com.atlassian.servicedesk.internal.feature.servicedesk.ServiceDeskInternalManager;
import com.atlassian.servicedesk.internal.permission.ServiceDeskProjectPermissionKeys;
import com.atlassian.servicedesk.internal.permission.misconfiguration.PermissionSchemeUtil;
import com.atlassian.servicedesk.internal.user.permission.roles.ServiceDeskJiraRoleManager;
import com.atlassian.servicedesk.internal.user.permission.roles.ServiceDeskProjectRole;
import com.atlassian.servicedesk.squalor.JIRAScreenAndSchemeCreator;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericEntityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncUpgradeTaskMigrateAgentPermission
implements SyncUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(SyncUpgradeTaskMigrateAgentPermission.class);
    private ServiceDeskInternalManager serviceDeskManager;
    private PermissionSchemeManager permissionSchemeManager;
    private MigrateAgentPermissionHelper migrateAgentPermissionHelper;
    private JIRAScreenAndSchemeCreator jiraScreenAndSchemeCreator;
    private PermissionSchemeUtil permissionSchemeUtil;
    private ServiceDeskJiraRoleManager serviceDeskJIRARoleManager;

    public SyncUpgradeTaskMigrateAgentPermission(ServiceDeskInternalManager serviceDeskManager, PermissionSchemeManager permissionSchemeManager, MigrateAgentPermissionHelper migrateAgentPermissionHelper, JIRAScreenAndSchemeCreator jiraScreenAndSchemeCreator, PermissionSchemeUtil permissionSchemeUtil, ServiceDeskJiraRoleManager serviceDeskJIRARoleManager) {
        this.serviceDeskManager = serviceDeskManager;
        this.permissionSchemeManager = permissionSchemeManager;
        this.migrateAgentPermissionHelper = migrateAgentPermissionHelper;
        this.jiraScreenAndSchemeCreator = jiraScreenAndSchemeCreator;
        this.permissionSchemeUtil = permissionSchemeUtil;
        this.serviceDeskJIRARoleManager = serviceDeskJIRARoleManager;
    }

    public String getVersionIntroduced() {
        return "3.0-OD-xx";
    }

    public void doUpgrade() {
        this.performUpgradeAgentPermission();
    }

    public String getVersionMigratedFromAsync() {
        return "3.1-OD-12";
    }

    public String getAsyncTaskName() {
        return "AsyncUpgradeTaskMigrateAgentPermission";
    }

    void performUpgradeAgentPermission() {
        String renaissanceMigrationType = this.migrateAgentPermissionHelper.getRenaissanceMigrationType();
        if (renaissanceMigrationType == null) {
            log.info("No Renaissance migration type found because the data is created in Renaissance mode already");
            return;
        }
        if ("none".equals(renaissanceMigrationType)) {
            log.info("No Service Desk license found during JIRA Renaissance migration");
            return;
        }
        if (!"TBP".equals(renaissanceMigrationType) && !"ABP".equals(renaissanceMigrationType)) {
            String failureMessage = String.format("Unknown Renaissance migration type: %s. This indicates an error happened during JIRA Renaissance migration", renaissanceMigrationType);
            log.error(failureMessage);
            Thread.dumpStack();
            throw new RuntimeException(failureMessage);
        }
        List<Scheme> schemesUsedByServiceDesk = this.getPermissionSchemesUsedByServiceDesk();
        int successCount = 0;
        for (Scheme scheme : schemesUsedByServiceDesk) {
            if (!this.migrateAgentPermissionForPermissionScheme(scheme, renaissanceMigrationType)) continue;
            ++successCount;
        }
        if (successCount != schemesUsedByServiceDesk.size()) {
            throw new RuntimeException("There were schemes that have not migrated successfully yet. This upgrade task will rerun on next scheduled time");
        }
        log.info(String.format("All %d permission schemes use by service desk have been migrated successfully", successCount));
    }

    private boolean migrateAgentPermissionForPermissionScheme(Scheme scheme, String renaissanceMigrationType) {
        List<SchemeEntity> permissionEntriesNeedToBeMigrated = this.getPermissionEntitiesNeedToBeMigrated(scheme, renaissanceMigrationType);
        List<SchemeEntity> filteredPermissionEntries = this.filterInvalidEntries(scheme, permissionEntriesNeedToBeMigrated);
        try {
            for (SchemeEntity permissionEntity : filteredPermissionEntries) {
                this.jiraScreenAndSchemeCreator.addEntityToPermissionScheme(scheme, permissionEntity.getType(), permissionEntity.getParameter(), ServiceDeskProjectPermissionKeys.SERVICEDESK_AGENT);
            }
            return true;
        }
        catch (GenericEntityException e) {
            log.error(String.format("There was an error when adding entity to Agent permission during upgrade task for permission scheme %s", scheme.getName()), (Throwable)e);
            return false;
        }
    }

    List<Scheme> getPermissionSchemesUsedByServiceDesk() {
        List allSchemes = this.permissionSchemeManager.getSchemeObjects();
        ArrayList schemesUsedByServiceDesk = Lists.newArrayList();
        for (Scheme scheme : allSchemes) {
            if (!this.isPermissionSchemeUsedByServiceDeskProject(scheme)) continue;
            schemesUsedByServiceDesk.add(scheme);
        }
        return schemesUsedByServiceDesk;
    }

    private boolean isPermissionSchemeUsedByServiceDeskProject(Scheme scheme) {
        List projects = this.permissionSchemeManager.getProjects(scheme);
        for (Project project : projects) {
            if (!this.serviceDeskManager.isServiceDeskEnabled(project)) continue;
            return true;
        }
        return false;
    }

    List<SchemeEntity> getPermissionEntitiesNeedToBeMigrated(Scheme projectScheme, String renaissanceMigrationType) {
        if ("ABP".equals(renaissanceMigrationType)) {
            return this.getPermissionEntities(projectScheme, ProjectPermissions.EDIT_ISSUES);
        }
        return this.getPermissionEntities(projectScheme, ProjectPermissions.BROWSE_PROJECTS);
    }

    List<SchemeEntity> getPermissionEntities(Scheme projectScheme, ProjectPermissionKey matchedPermissionKey) {
        ArrayList permissionEntities = Lists.newArrayList();
        Collection projectSchemeEntities = projectScheme.getEntities();
        for (SchemeEntity entity : projectSchemeEntities) {
            ProjectPermissionKey permissionKey = this.permissionSchemeUtil.getPermissionKeyFromEntity(entity);
            if (!matchedPermissionKey.equals((Object)permissionKey)) continue;
            permissionEntities.add(entity);
        }
        return permissionEntities;
    }

    List<SchemeEntity> filterInvalidEntries(Scheme projectScheme, List<SchemeEntity> permissionEntities) {
        ArrayList filteredEntities = Lists.newArrayList();
        for (SchemeEntity schemeEntity : permissionEntities) {
            if (!this.isSchemeEntityValid(schemeEntity) || !this.isNotPortalAccessSecurityType(schemeEntity) || !this.isNotInAgentPermission(projectScheme, schemeEntity)) continue;
            filteredEntities.add(schemeEntity);
        }
        return filteredEntities;
    }

    boolean isSchemeEntityValid(SchemeEntity schemeEntity) {
        Option<ProjectRole> collaboratorRole;
        boolean isValid = true;
        Option<ProjectRole> customerRole = this.serviceDeskJIRARoleManager.getRole(ServiceDeskProjectRole.CUSTOMER);
        if (customerRole.isDefined() && ((ProjectRole)customerRole.get()).getId().toString().equals(schemeEntity.getParameter())) {
            isValid = false;
        }
        if ((collaboratorRole = this.serviceDeskJIRARoleManager.getRole(ServiceDeskProjectRole.COLLABORATOR)).isDefined() && ((ProjectRole)collaboratorRole.get()).getId().toString().equals(schemeEntity.getParameter())) {
            isValid = false;
        }
        return isValid;
    }

    boolean isNotPortalAccessSecurityType(SchemeEntity schemeEntity) {
        return !"sd.customer.portal.only".equals(schemeEntity.getType());
    }

    boolean isNotInAgentPermission(Scheme projectScheme, SchemeEntity schemeEntity) {
        List<SchemeEntity> agentPermissionEntities = this.getPermissionEntities(projectScheme, ServiceDeskProjectPermissionKeys.SERVICEDESK_AGENT);
        for (SchemeEntity agentPermissionEntity : agentPermissionEntities) {
            if (!StringUtils.equals((String)agentPermissionEntity.getType(), (String)schemeEntity.getType()) || !StringUtils.equals((String)agentPermissionEntity.getParameter(), (String)schemeEntity.getParameter())) continue;
            return false;
        }
        return true;
    }
}

