/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.bootstrap.upgrade.registry;

import com.atlassian.pocketknife.api.autowire.PluginAutowirer;
import com.atlassian.pocketknife.api.lifecycle.services.OptionalService;
import com.atlassian.pocketknife.spi.lifecycle.services.OptionalServiceAccessor;
import com.atlassian.servicedesk.internal.api.bootstrap.upgrade.JSDUpgradeTask;
import org.osgi.framework.BundleContext;

public abstract class UpgradeTaskReference<T extends JSDUpgradeTask> {
    public static <U extends JSDUpgradeTask> UpgradeTaskReference<U> fromClass(Class<U> type) {
        return new ClassReference(type);
    }

    public static <U extends JSDUpgradeTask> UpgradeTaskReference<U> fromOtherPlugin(String serviceName) {
        return new ServiceReference(serviceName);
    }

    public abstract T getInstance(PluginAutowirer var1, BundleContext var2);

    private static final class ServiceReference<T extends JSDUpgradeTask>
    extends UpgradeTaskReference<T> {
        private final String serviceName;

        private ServiceReference(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public T getInstance(PluginAutowirer pluginAutowirer, BundleContext bundleContext) {
            OptionalServiceAccessor accessor = new OptionalServiceAccessor(bundleContext, this.serviceName);
            OptionalService service2 = accessor.obtain();
            if (service2.isAvailable()) {
                return (T)((JSDUpgradeTask)service2.get());
            }
            throw new RuntimeException("Could not find upgrade task with OSGi service name " + this.serviceName);
        }
    }

    private static final class ClassReference<T extends JSDUpgradeTask>
    extends UpgradeTaskReference<T> {
        private final Class<T> type;

        private ClassReference(Class<T> type) {
            this.type = type;
        }

        @Override
        public T getInstance(PluginAutowirer pluginAutowirer, BundleContext bundleContext) {
            return (T)((JSDUpgradeTask)pluginAutowirer.autowire(this.type));
        }
    }
}

