/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.bootstrap.upgrade.helper;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.apache.log4j.Logger;

public class VariableFrequencyProgressLogger {
    private static final Long DEFAULT_LOG_INV_FREQUENCY = 1L;
    private long upgradeCount = 0L;
    private Logger logger;
    private Function<Long, String> logMessageBuilder;
    private List<LogRangeFrequency> logRangeFrequencies;

    private VariableFrequencyProgressLogger(Logger logger, Function<Long, String> logMessageBuilder, List<LogRangeFrequency> logRangeFrequencies) {
        this.logger = logger;
        this.logMessageBuilder = logMessageBuilder;
        this.logRangeFrequencies = logRangeFrequencies;
    }

    public void onUpgradeProgress() {
        ++this.upgradeCount;
        if (this.shouldLog()) {
            this.logger.info((Object)this.logMessageBuilder.apply(this.upgradeCount));
        }
    }

    private boolean shouldLog() {
        return this.upgradeCount % this.getCurrentLogInverseFrequency() == 0L;
    }

    private long getCurrentLogInverseFrequency() {
        Iterator iterator = this.getCurrentLogRangeFrequency().iterator();
        if (iterator.hasNext()) {
            LogRangeFrequency currentLogRangeFrequency = (LogRangeFrequency)iterator.next();
            return currentLogRangeFrequency.logInverseFrequency;
        }
        return DEFAULT_LOG_INV_FREQUENCY;
    }

    private Option<LogRangeFrequency> getCurrentLogRangeFrequency() {
        Option applicableLogRangeOpt = Option.none();
        for (LogRangeFrequency logRangeFrequency : this.logRangeFrequencies) {
            if (this.upgradeCount < logRangeFrequency.rangeStart) continue;
            applicableLogRangeOpt = Option.some((Object)logRangeFrequency);
        }
        return applicableLogRangeOpt;
    }

    public static class VariableFrequencyProgressLoggerBuilder {
        private Logger logger;
        private Function<Long, String> logMessageBuilder;
        private List<LogRangeFrequency> logRangeFrequencies;

        public VariableFrequencyProgressLoggerBuilder(Logger logger, Function<Long, String> logMessageBuilder) {
            this.logger = logger;
            this.logMessageBuilder = logMessageBuilder;
            this.logRangeFrequencies = Lists.newArrayList();
        }

        public VariableFrequencyProgressLoggerBuilder withLogFrequencyRange(long rangeStart, long logInverseFrequency) {
            Preconditions.checkArgument((rangeStart >= 0L ? 1 : 0) != 0, (Object)"rangeStart must be non-negative");
            Preconditions.checkArgument((logInverseFrequency > 0L ? 1 : 0) != 0, (Object)"logInverseFrequency frequency must be positive");
            if (!this.logRangeFrequencies.isEmpty()) {
                LogRangeFrequency lastLogRangeFrequency = this.logRangeFrequencies.get(this.logRangeFrequencies.size() - 1);
                Preconditions.checkArgument((rangeStart > lastLogRangeFrequency.rangeStart ? 1 : 0) != 0, (Object)"rangeStart must be greater than previous range start");
            }
            this.logRangeFrequencies.add(new LogRangeFrequency(rangeStart, logInverseFrequency));
            return this;
        }

        public VariableFrequencyProgressLogger build() {
            return new VariableFrequencyProgressLogger(this.logger, this.logMessageBuilder, this.logRangeFrequencies);
        }
    }

    private static class LogRangeFrequency {
        public final long rangeStart;
        public final long logInverseFrequency;

        public LogRangeFrequency(long rangeStart, long logInverseFrequency) {
            this.rangeStart = rangeStart;
            this.logInverseFrequency = logInverseFrequency;
        }
    }
}

