/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.bootstrap.upgrade.helper;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.pocketknife.api.querydsl.stream.CloseableIterable;
import com.atlassian.pocketknife.api.querydsl.stream.StreamingQueryFactory;
import com.atlassian.pocketknife.spi.querydsl.EnhancedRelationalPathBase;
import com.atlassian.servicedesk.internal.querydsl.mapping.Tables;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.sql.SQLQuery;
import io.atlassian.fugue.Effect;
import io.atlassian.fugue.Option;
import java.util.function.Supplier;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AsyncUpgradeTaskServiceDeskIssuesDbHelper {
    private final StreamingQueryFactory streamingQueryFactory;
    private final DatabaseAccessor databaseAccessor;
    private final IssueManager issueManager;

    @Autowired
    public AsyncUpgradeTaskServiceDeskIssuesDbHelper(StreamingQueryFactory streamingQueryFactory, DatabaseAccessor databaseAccessor, IssueManager issueManager) {
        this.streamingQueryFactory = streamingQueryFactory;
        this.databaseAccessor = databaseAccessor;
        this.issueManager = issueManager;
    }

    private CloseableIterable<Long> getAllServiceDeskIssueIds(DatabaseConnection conn) {
        QJiraIssueForUpgradeTask JIRA_ISSUE = new QJiraIssueForUpgradeTask();
        Supplier<SQLQuery> querySupplier = () -> (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)conn.select(JIRA_ISSUE.ID).from((Expression)JIRA_ISSUE)).join((EntityPath)Tables.SERVICE_DESK)).on((Predicate)Tables.SERVICE_DESK.PROJECT_ID.eq(JIRA_ISSUE.PROJECT_ID))).orderBy(JIRA_ISSUE.ID.asc());
        return this.streamingQueryFactory.stream(conn, querySupplier);
    }

    private Void runEffects(DatabaseConnection conn, Effect<Issue> issueUpgradeEffect) {
        try (CloseableIterable<Long> issueIdsIterable = this.getAllServiceDeskIssueIds(conn);){
            for (Long issueId : issueIdsIterable) {
                Option issueOpt = Option.option((Object)this.issueManager.getIssueObject(issueId));
                issueOpt.foreach(issueUpgradeEffect);
            }
        }
        return null;
    }

    public Void applyEffectForAllServiceDeskIssues(Effect<Issue> issueUpgradeEffect) {
        return (Void)this.databaseAccessor.run(conn -> this.runEffects((DatabaseConnection)conn, issueUpgradeEffect));
    }

    private static final class QJiraIssueForUpgradeTask
    extends EnhancedRelationalPathBase<QJiraIssueForUpgradeTask> {
        private static final String TABLE_NAME_CASE_INSENSITIVE = "JIRAISSUE";
        public final NumberPath<Long> ID = (NumberPath)this.createLongCol("ID").asPrimaryKey().build();
        public final NumberPath<Long> PROJECT_ID = (NumberPath)this.createLongCol("PROJECT").build();

        private QJiraIssueForUpgradeTask() {
            super(QJiraIssueForUpgradeTask.class, TABLE_NAME_CASE_INSENSITIVE);
        }
    }
}

