/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.bootstrap.upgrade;

import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.internal.logging.LoggingUtil;
import com.atlassian.servicedesk.bootstrap.upgrade.SyncUpgradeTaskException;
import com.atlassian.servicedesk.bootstrap.upgrade.SyncUpgradeTaskRecordStore;
import com.atlassian.servicedesk.bootstrap.upgrade.SyncUpgradeTaskRegistration;
import com.atlassian.servicedesk.bootstrap.upgrade.SyncUpgradeTaskService;
import com.atlassian.servicedesk.internal.api.bootstrap.upgrade.SyncUpgradeTask;
import com.atlassian.servicedesk.internal.upgrade.AsyncUpgradeTaskRecordQStore;
import io.atlassian.fugue.Option;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SyncUpgradeTaskServiceImpl
implements SyncUpgradeTaskService {
    private static final Logger log = LoggerFactory.getLogger(SyncUpgradeTaskServiceImpl.class);
    private final AsyncUpgradeTaskRecordQStore asyncUpgradeTaskRecordStore;
    private final SyncUpgradeTaskRecordStore syncUpgradeTaskRecordStore;
    private final SyncUpgradeTaskRegistration syncUpgradeTaskRegistration;
    private final I18nHelper i18nHelper;

    @Autowired
    public SyncUpgradeTaskServiceImpl(AsyncUpgradeTaskRecordQStore asyncUpgradeTaskRecordStore, SyncUpgradeTaskRecordStore syncUpgradeTaskRecordStore, SyncUpgradeTaskRegistration syncUpgradeTaskRegistration, I18nHelper i18nHelper) {
        this.asyncUpgradeTaskRecordStore = asyncUpgradeTaskRecordStore;
        this.syncUpgradeTaskRecordStore = syncUpgradeTaskRecordStore;
        this.syncUpgradeTaskRegistration = syncUpgradeTaskRegistration;
        this.i18nHelper = i18nHelper;
        LoggingUtil.setLevelToInfoIfNotDefined(log);
    }

    @Override
    public void runAll() throws SyncUpgradeTaskException {
        for (SyncUpgradeTask task : this.syncUpgradeTaskRegistration.getOrderedUpgradeTasks()) {
            this.runTask(task);
        }
    }

    private void runTask(SyncUpgradeTask task) throws SyncUpgradeTaskException {
        Class<?> taskClazz = task.getClass();
        try {
            if (StringUtils.isNotBlank((String)task.getAsyncTaskName()) && this.asyncUpgradeTaskRecordStore.hasTaskCompleted(task.getAsyncTaskName())) {
                return;
            }
            if (this.syncUpgradeTaskRecordStore.hasTaskCompleted(taskClazz)) {
                return;
            }
            this.syncUpgradeTaskRecordStore.writeStartRecord(taskClazz);
            log.info("Starting sync upgrade task: " + taskClazz.getSimpleName());
            task.doUpgrade();
            this.syncUpgradeTaskRecordStore.writeCompleteRecord(taskClazz);
        }
        catch (Exception e) {
            String errorMessage = this.i18nHelper.getText("sd.upgrade.task.error.failure.message.with.exception.message", taskClazz.getSimpleName(), e.getMessage());
            log.error(errorMessage, (Throwable)e);
            this.syncUpgradeTaskRecordStore.writeFailureRecord(taskClazz, (Option<String>)Option.option((Object)e.getMessage()), (Option<String>)Option.some((Object)e.getClass().getSimpleName()));
            throw new SyncUpgradeTaskException("Failed running SyncUpgradeTask: " + taskClazz.getSimpleName(), e);
        }
    }

    @Override
    public void runTaskByClassName(String className) throws SyncUpgradeTaskException {
        Option<SyncUpgradeTask> task = this.syncUpgradeTaskRegistration.getTaskByClassName(className);
        if (task.isEmpty()) {
            log.error("Upgrade task " + className + " could not be found. Has the task been registered?");
        } else {
            this.runTask((SyncUpgradeTask)task.get());
        }
    }
}

