/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.bootstrap.upgrade;

import com.atlassian.fugue.Either;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.ErrorBuilder;
import com.atlassian.pocketknife.api.commons.error.ErrorCode;
import com.atlassian.pocketknife.api.commons.error.Errors;
import com.atlassian.pocketknife.api.commons.error.HttpStatusCode;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.api.commons.result.ServiceResult;
import com.atlassian.pocketknife.api.commons.result.Unit;
import com.atlassian.pocketknife.internal.logging.LoggingUtil;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.bootstrap.upgrade.AsyncUpgradeTaskExecutionContext;
import com.atlassian.servicedesk.bootstrap.upgrade.AsyncUpgradeTaskRegistration;
import com.atlassian.servicedesk.bootstrap.upgrade.InternalAsyncUpgradeTaskService;
import com.atlassian.servicedesk.internal.api.bootstrap.upgrade.AsyncUpgradeTask;
import com.atlassian.servicedesk.internal.api.bootstrap.upgrade.AsyncUpgradeTaskResult;
import com.atlassian.servicedesk.internal.api.bootstrap.upgrade.AsyncUpgradeTaskService;
import com.atlassian.servicedesk.internal.upgrade.AsyncUpgradeTaskRecord;
import com.atlassian.servicedesk.internal.upgrade.AsyncUpgradeTaskRecordQStore;
import com.atlassian.servicedesk.internal.utils.CacheUtil;
import com.atlassian.upgrade.api.UpgradeTaskService;
import com.atlassian.vcache.RequestCache;
import com.atlassian.vcache.VCacheFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={AsyncUpgradeTaskService.class})
public class AsyncUpgradeTaskServiceImpl
implements InternalAsyncUpgradeTaskService {
    private static final String I18N_TASK_NOT_FOUND_MSG_KEY = "sd.async.upgrade.task.error.independent.task.not.found";
    private static final Logger log = LoggerFactory.getLogger(AsyncUpgradeTaskServiceImpl.class);
    private final UpgradeTaskService upgradeTaskService;
    private final AsyncUpgradeTaskRegistration asyncUpgradeTaskRegistration;
    private final AsyncUpgradeTaskRecordQStore asyncUpgradeTaskRecordStore;
    private final I18nHelper i18nHelper;
    private final ErrorResultHelper errorResultHelper;
    private final RequestCache<String, io.atlassian.fugue.Either<AnError, Boolean>> hasTaskCompletedCache;

    @Autowired
    public AsyncUpgradeTaskServiceImpl(AsyncUpgradeTaskRegistration asyncUpgradeTaskRegistration, AsyncUpgradeTaskRecordQStore asyncUpgradeTaskRecordStore, I18nHelper i18nHelper, ErrorResultHelper errorResultHelper, VCacheFactory cacheFactory, UpgradeTaskService upgradeTaskService) {
        this.asyncUpgradeTaskRecordStore = asyncUpgradeTaskRecordStore;
        this.asyncUpgradeTaskRegistration = asyncUpgradeTaskRegistration;
        this.i18nHelper = i18nHelper;
        this.errorResultHelper = errorResultHelper;
        this.hasTaskCompletedCache = cacheFactory.getRequestCache(CacheUtil.standardName(this, "asyncUpgradeTaskServiceHasTaskCompletedCache"));
        this.upgradeTaskService = upgradeTaskService;
        LoggingUtil.setLevelToInfoIfNotDefined(log);
    }

    @Override
    public synchronized io.atlassian.fugue.Either<Errors, Unit> runAll() {
        ArrayList aggregatedErrors = Lists.newArrayList();
        io.atlassian.fugue.Either<Errors, Unit> orderedExecutionResult = this.runOrderedTasks();
        if (orderedExecutionResult.isLeft()) {
            aggregatedErrors.addAll(((Errors)orderedExecutionResult.left().get()).getErrors());
        }
        if (!aggregatedErrors.isEmpty()) {
            return StepsConverters.newerEither((Either)ServiceResult.errors((Errors)new Errors((List)aggregatedErrors, HttpStatusCode.INTERNAL_SERVER_ERROR, new ErrorCode(this.i18nHelper.getText("sd.async.upgrade.task.error.errors.occured")))));
        }
        return StepsConverters.newerEither((Either)ServiceResult.ok());
    }

    @Override
    @Deprecated
    public synchronized io.atlassian.fugue.Either<AnError, Unit> runSingleUpgradeTaskByClassName(String className) {
        Option<AsyncUpgradeTask> independentTask = this.asyncUpgradeTaskRegistration.getTaskByClassName(className);
        if (independentTask.isEmpty()) {
            return io.atlassian.fugue.Either.left((Object)ErrorBuilder.errorBuilder().errorCode(new ErrorCode(this.i18nHelper.getText("sd.async.upgrade.task.error.errors.occured"))).addError(this.i18nHelper.getText(I18N_TASK_NOT_FOUND_MSG_KEY), I18N_TASK_NOT_FOUND_MSG_KEY).httpStatusCode(HttpStatusCode.NOT_FOUND).buildSingleError());
        }
        return this.runTask((AsyncUpgradeTask)independentTask.get());
    }

    @Override
    public List<AsyncUpgradeTaskRecord> getUpgradeTasksRecords() {
        return this.asyncUpgradeTaskRecordStore.getRecords();
    }

    public io.atlassian.fugue.Either<AnError, Boolean> hasTaskCompleted(String className) {
        io.atlassian.fugue.Either hasCompletedEither = (io.atlassian.fugue.Either)this.hasTaskCompletedCache.get((Object)className, () -> this.loadCompletionResult(className));
        if (hasCompletedEither.isLeft()) {
            this.invalidateHasTaskCompletedCache(className);
        }
        return hasCompletedEither;
    }

    @VisibleForTesting
    io.atlassian.fugue.Either<AnError, Boolean> loadCompletionResult(@Nonnull String className) {
        return (io.atlassian.fugue.Either)this.asyncUpgradeTaskRegistration.getTaskByClassName(className).fold(() -> AsyncUpgradeTaskServiceImpl.buildTaskNotFoundError(this.errorResultHelper, className), task -> io.atlassian.fugue.Either.right((Object)this.hasTaskCompleteInEitherSystem((AsyncUpgradeTask)task)));
    }

    private boolean hasTaskCompleteInEitherSystem(AsyncUpgradeTask task) {
        boolean completedWithOldUTSystem = this.checkUpgradeTaskCompleteWithServiceDeskDatabase(task);
        boolean completeWithUpgradeTaskService = this.checkUpgradeTaskCompleteWithUpgradeTaskService(task);
        log.info("{} has completed ? oldSystem: {}, upgrade task service: {}", new Object[]{task, completedWithOldUTSystem, completeWithUpgradeTaskService});
        return completedWithOldUTSystem || completeWithUpgradeTaskService;
    }

    private boolean checkUpgradeTaskCompleteWithUpgradeTaskService(AsyncUpgradeTask task) {
        return this.upgradeTaskService.getDatabaseBuildNumber() >= task.getBuildNumber();
    }

    private boolean checkUpgradeTaskCompleteWithServiceDeskDatabase(AsyncUpgradeTask task) {
        return this.asyncUpgradeTaskRecordStore.hasTaskCompleted(task.getClass());
    }

    private io.atlassian.fugue.Either<Errors, Unit> runOrderedTasks() {
        AsyncUpgradeTaskExecutionContext executionContext = new AsyncUpgradeTaskExecutionContext();
        executionContext.setStopOnFirstExecutionFailure(true);
        return this.runTasks(this.asyncUpgradeTaskRegistration.getAsyncUpgradeTasks(), executionContext);
    }

    private io.atlassian.fugue.Either<Errors, Unit> runTasks(List<AsyncUpgradeTask> tasks, AsyncUpgradeTaskExecutionContext executionContext) {
        ArrayList executionErrors = Lists.newArrayList();
        for (AsyncUpgradeTask task : tasks) {
            io.atlassian.fugue.Either<AnError, Unit> taskExecutionResult = this.runTask(task);
            if (!taskExecutionResult.isLeft()) continue;
            executionErrors.add(((AnError)taskExecutionResult.left().get()).getMessage());
            if (!executionContext.isStopOnFirstExecutionFailure()) continue;
            break;
        }
        if (!executionErrors.isEmpty()) {
            return StepsConverters.newerEither((Either)ServiceResult.errors((Errors)new Errors((List)executionErrors, HttpStatusCode.INTERNAL_SERVER_ERROR)));
        }
        return StepsConverters.newerEither((Either)ServiceResult.ok());
    }

    private io.atlassian.fugue.Either<AnError, Unit> runTask(AsyncUpgradeTask task) {
        Class<?> taskClazz = task.getClass();
        if (!this.asyncUpgradeTaskRecordStore.hasTaskCompleted(taskClazz)) {
            this.invalidateHasTaskCompletedCache(task);
            this.asyncUpgradeTaskRecordStore.writeStartRecord(taskClazz);
            log.info("Starting upgrade task: " + taskClazz.getSimpleName());
            try {
                AsyncUpgradeTaskResult result = task.doUpgrade();
                switch (result.getOutcome()) {
                    case SUCCEEDED: {
                        this.handleSuccessOutcome(taskClazz, result);
                        return StepsConverters.newerEither((Either)ServiceResult.ok());
                    }
                    case FAILED: {
                        AnError upgradeTaskFailureError = this.handleFailureOutcomeAndGetError(taskClazz, result);
                        return StepsConverters.newerEither((Either)ServiceResult.error((AnError)upgradeTaskFailureError));
                    }
                }
            }
            catch (Exception e) {
                AnError upgradeTaskFailureError = this.handleExceptionAndGetError(taskClazz, e);
                log.error(upgradeTaskFailureError.getMessage().getMessage(), (Throwable)e);
                return StepsConverters.newerEither((Either)ServiceResult.error((AnError)upgradeTaskFailureError));
            }
        }
        log.info("{} is already COMPLETED, skipping", taskClazz);
        return StepsConverters.newerEither((Either)ServiceResult.ok());
    }

    private void handleSuccessOutcome(Class<? extends AsyncUpgradeTask> task, AsyncUpgradeTaskResult result) {
        this.asyncUpgradeTaskRecordStore.writeCompleteRecord(task, result);
        this.invalidateHasTaskCompletedCache(task);
        log.info("Finished upgrade task: " + task.getSimpleName());
    }

    private AnError handleFailureOutcomeAndGetError(Class<? extends AsyncUpgradeTask> task, AsyncUpgradeTaskResult result) {
        this.asyncUpgradeTaskRecordStore.writeFailureRecord(task, (Option<String>)result.getMessage(), (Option<String>)Option.none(String.class));
        this.invalidateHasTaskCompletedCache(task);
        return this.buildAndLogError(task, (Option<AsyncUpgradeTaskResult>)Option.some((Object)result), (Option<Exception>)Option.none(Exception.class));
    }

    private AnError handleExceptionAndGetError(Class<? extends AsyncUpgradeTask> task, Exception e) {
        String exceptionMessage = Throwables.getStackTraceAsString((Throwable)e);
        this.asyncUpgradeTaskRecordStore.writeFailureRecord(task, (Option<String>)Option.none(String.class), (Option<String>)Option.some((Object)exceptionMessage));
        this.invalidateHasTaskCompletedCache(task);
        return this.buildAndLogError(task, (Option<AsyncUpgradeTaskResult>)Option.none(AsyncUpgradeTaskResult.class), (Option<Exception>)Option.some((Object)e));
    }

    private AnError buildAndLogError(Class<? extends AsyncUpgradeTask> task, Option<AsyncUpgradeTaskResult> result, Option<Exception> e) {
        AnError upgradeTaskFailureError = this.buildError(task, result, e);
        log.info(upgradeTaskFailureError.getMessage().getMessage());
        return upgradeTaskFailureError;
    }

    private AnError buildError(Class<? extends AsyncUpgradeTask> upgradeTask, Option<AsyncUpgradeTaskResult> result, Option<Exception> e) {
        return ErrorBuilder.errorBuilder().addError(this.getUpgradeTaskUnsuccessfulMessage(upgradeTask, result, e)).httpStatusCode(HttpStatusCode.INTERNAL_SERVER_ERROR).buildSingleError();
    }

    private String getUpgradeTaskUnsuccessfulMessage(Class<? extends AsyncUpgradeTask> upgradeTask, Option<AsyncUpgradeTaskResult> resultOpt, Option<Exception> exception) {
        if (exception.isDefined()) {
            return this.getText("sd.upgrade.task.error.failure.message.with.exception.message", upgradeTask.getSimpleName(), ((Exception)exception.get()).getMessage());
        }
        if (resultOpt.isDefined()) {
            return this.getText("sd.async.upgrade.task.error.failure.message", upgradeTask.getSimpleName());
        }
        return "Execution result is unknown";
    }

    private String getText(String key, Object ... params) {
        return this.i18nHelper.getText(key, (Object)params);
    }

    private void invalidateHasTaskCompletedCache(AsyncUpgradeTask task) {
        this.invalidateHasTaskCompletedCache(task.getClass());
    }

    private void invalidateHasTaskCompletedCache(Class<? extends AsyncUpgradeTask> task) {
        this.invalidateHasTaskCompletedCache(task.getSimpleName());
    }

    private void invalidateHasTaskCompletedCache(String className) {
        this.hasTaskCompletedCache.remove((Object)className);
    }

    private static <T> io.atlassian.fugue.Either<AnError, T> buildTaskNotFoundError(ErrorResultHelper errorResultHelper, String className) {
        log.warn("upgradeTask {} not found", (Object)className);
        return StepsConverters.newerEither((Either)errorResultHelper.error(HttpStatusCode.NOT_FOUND, I18N_TASK_NOT_FOUND_MSG_KEY, new Object[]{className}));
    }
}

