/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.bootstrap.upgrade;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.pocketknife.api.logging.LoggingSupport;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.servicedesk.bootstrap.upgrade.AsyncUpgradeTaskJobRunner;
import com.atlassian.servicedesk.internal.featureflag.SDFeatureFlags;
import java.util.Date;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AsyncUpgradeTaskScheduler {
    private static final long MAX_JITTER = Duration.standardHours((long)2L).getMillis();
    private static final long MIN_DELAY = Duration.standardHours((long)1L).getMillis();
    private final PeriodFormatter hoursMinutesAndSeconds = new PeriodFormatterBuilder().printZeroAlways().minimumPrintedDigits(2).appendHours().appendSeparator(":").appendMinutes().appendSeparator(":").appendSeconds().toFormatter();
    @Autowired
    private LoggingSupport loggingSupport;
    @Autowired
    private AsyncUpgradeTaskJobRunner asyncUpgradeTaskJobRunner;
    @Autowired
    private SchedulerService schedulerService;
    @Autowired
    private FeatureManager featureManager;

    public void scheduleAsyncUpgradeTasks() throws SchedulerServiceException {
        Date currentDate = DateTime.now().toDate();
        if (this.featureManager.isEnabled(SDFeatureFlags.ASYNC_UPGRADE_TASKS_NOT_SCHEDULED)) {
            this.loggingSupport.log().info("Service Desk async job runner has not been scheduled at " + currentDate.toString() + " due to Feature Flag");
            return;
        }
        this.loggingSupport.log().info("Registering Service Desk async job runner");
        this.schedulerService.registerJobRunner(AsyncUpgradeTaskJobRunner.JOB_RUNNER_KEY, (JobRunner)this.asyncUpgradeTaskJobRunner);
        this.loggingSupport.log().info("Registered Service Desk async job runner successfully");
        Date runDate = this.calculateRunDate(currentDate);
        Duration interval = Duration.millis((long)runDate.getTime()).minus(currentDate.getTime());
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)AsyncUpgradeTaskJobRunner.JOB_RUNNER_KEY).withSchedule(Schedule.runOnce((Date)runDate)).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER);
        this.loggingSupport.log().info("Service Desk Async upgrade tasks set to run at " + runDate.toString() + " (in " + this.hoursMinutesAndSeconds.print((ReadablePeriod)interval.toPeriod()) + " from current date of " + currentDate.toString() + ")");
        this.schedulerService.scheduleJob(AsyncUpgradeTaskJobRunner.JOB_ID, jobConfig);
        this.loggingSupport.log().info("Successfully scheduled jobId=" + AsyncUpgradeTaskJobRunner.JOB_ID);
    }

    public void unscheduleAsyncUpgradeTasks() {
        this.schedulerService.unscheduleJob(AsyncUpgradeTaskJobRunner.JOB_ID);
        this.loggingSupport.log().info("Successfully unscheduled jobId=" + AsyncUpgradeTaskJobRunner.JOB_ID);
        this.loggingSupport.log().info("Unregistering Service Desk async job runner");
        this.schedulerService.unregisterJobRunner(AsyncUpgradeTaskJobRunner.JOB_RUNNER_KEY);
        this.loggingSupport.log().info("Unregistered Service Desk async job runner successfully");
    }

    private Date calculateRunDate(Date startDate) {
        long jitter = (long)(Math.random() * (double)MAX_JITTER);
        return new Date(startDate.getTime() + MIN_DELAY + jitter);
    }
}

