/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.bootstrap.upgrade;

import com.atlassian.pocketknife.api.autowire.PluginAutowirer;
import com.atlassian.servicedesk.bootstrap.upgrade.registry.UpgradeTaskReference;
import com.atlassian.servicedesk.bootstrap.upgrade.registry.UpgradeTaskRegistry;
import com.atlassian.servicedesk.bootstrap.upgrade.task.commentautotransition.AsyncUpgradeTaskMigrateCommentAutotransition;
import com.atlassian.servicedesk.bootstrap.upgrade.tasks.AsyncUpgradeTaskAddOrganisationFieldToScreens;
import com.atlassian.servicedesk.bootstrap.upgrade.tasks.AsyncUpgradeTaskAddParticipantFieldToScreens;
import com.atlassian.servicedesk.bootstrap.upgrade.tasks.AsyncUpgradeTaskLockVpOriginField;
import com.atlassian.servicedesk.internal.api.bootstrap.upgrade.AsyncUpgradeTask;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import io.atlassian.fugue.Option;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AsyncUpgradeTaskRegistration {
    private static final Logger log = LoggerFactory.getLogger(AsyncUpgradeTaskRegistration.class);
    private static List<UpgradeTaskReference<? extends AsyncUpgradeTask>> UPGRADE_TASK_CLASSES = ImmutableList.of(UpgradeTaskReference.fromClass(AsyncUpgradeTaskAddParticipantFieldToScreens.class), UpgradeTaskReference.fromClass(AsyncUpgradeTaskMigrateCommentAutotransition.class), UpgradeTaskReference.fromClass(AsyncUpgradeTaskLockVpOriginField.class), UpgradeTaskReference.fromClass(AsyncUpgradeTaskAddOrganisationFieldToScreens.class));
    private final UpgradeTaskRegistry<AsyncUpgradeTask> upgradeTaskRegistry;

    @Autowired
    public AsyncUpgradeTaskRegistration(PluginAutowirer pluginAutowirer, BundleContext bundleContext) {
        this.upgradeTaskRegistry = new UpgradeTaskRegistry<AsyncUpgradeTask>(UPGRADE_TASK_CLASSES, pluginAutowirer, bundleContext);
    }

    public List<AsyncUpgradeTask> getAsyncUpgradeTasks() {
        return this.upgradeTaskRegistry.getAll();
    }

    public boolean buildNumbersAreUnique() {
        return this.buildNumbersAreUnique(this.getAsyncUpgradeTasks());
    }

    @VisibleForTesting
    boolean buildNumbersAreUnique(List<AsyncUpgradeTask> upgradeTasks) {
        boolean noRepeatedBuildNumber = true;
        Map<Integer, List<AsyncUpgradeTask>> upgradeTaskByBuildNumber = upgradeTasks.stream().collect(Collectors.groupingBy(AsyncUpgradeTask::getBuildNumber));
        for (Integer buildNumber : upgradeTaskByBuildNumber.keySet()) {
            if (upgradeTaskByBuildNumber.get(buildNumber).size() <= 1) continue;
            noRepeatedBuildNumber = false;
            log.error("Detect repeated buildNumbers in Upgradetasks: {} with buildNumber:{}", upgradeTaskByBuildNumber.get(buildNumber), (Object)buildNumber);
        }
        return noRepeatedBuildNumber;
    }

    public Option<AsyncUpgradeTask> getTaskByClassName(String className) {
        return this.upgradeTaskRegistry.getByClassName(className);
    }
}

