/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.bootstrap.lifecycle.server;

import com.atlassian.pocketknife.api.upgrade.PluginRunInfo;
import com.atlassian.pocketknife.api.version.SoftwareVersion;
import com.atlassian.servicedesk.bootstrap.lifecycle.server.UnsatisfiedVersionRequirementException;
import org.springframework.stereotype.Component;

@Component
public class UpgradeRequirementsChecker {
    private static final String MINIMAL_REQUIRED_VERSION_FOR_UPGRADE = "3.0.0";
    private static final String MAXIMUM_REQUIRED_VERSION_FOR_UPGRADE = "3.2.0";

    public void checkVersionRequirementForUpgrade(PluginRunInfo pluginRunInfo) throws UnsatisfiedVersionRequirementException {
        SoftwareVersion requiredVersion;
        SoftwareVersion previousVersion = new SoftwareVersion(pluginRunInfo.getPreviousVersion());
        if (previousVersion.isLessThan(requiredVersion = new SoftwareVersion(MINIMAL_REQUIRED_VERSION_FOR_UPGRADE))) {
            throw new UnsatisfiedVersionRequirementException(pluginRunInfo.getPreviousVersion(), pluginRunInfo.getCurrentVersion(), MINIMAL_REQUIRED_VERSION_FOR_UPGRADE, MAXIMUM_REQUIRED_VERSION_FOR_UPGRADE);
        }
    }
}

