/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.bootstrap.lifecycle.server;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.pocketknife.api.tracker.InvariantModuleTracker;
import com.atlassian.servicedesk.bootstrap.listener.EventListenerLauncher;
import com.atlassian.servicedesk.internal.api.customfields.feedback.RequestFeedbackCFManager;
import com.atlassian.servicedesk.internal.api.customfields.feedback.RequestFeedbackDateCFManager;
import com.atlassian.servicedesk.internal.api.customfields.origin.VpOriginCustomFieldService;
import com.atlassian.servicedesk.internal.customfields.organization.CustomerOrganizationsCFManager;
import com.atlassian.servicedesk.internal.customfields.participants.ParticipantsCustomFieldManager;
import com.atlassian.servicedesk.internal.feature.queue.QueueServiceOffThreadRegistration;
import com.atlassian.servicedesk.internal.featureflag.SDFeatureFlags;
import com.atlassian.servicedesk.internal.notifications.watchers.AutoWatchHandlerPatcher;
import com.atlassian.servicedesk.internal.permission.security.role.ServiceDeskRoleCreation;
import com.atlassian.servicedesk.internal.permission.security.type.ServiceDeskSecurityTypeInstaller;
import com.atlassian.servicedesk.internal.timedpromise.TimedPromiseStartupTaskRegistrar;
import io.atlassian.fugue.Option;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PluginInitializer {
    private static final Logger log = Logger.getLogger(PluginInitializer.class);
    private final PluginEventManager pluginEventManager;
    private final EventPublisher eventPublisher;
    private final VpOriginCustomFieldService vpOriginCustomFieldService;
    private final ParticipantsCustomFieldManager participantsCustomFieldManager;
    private final CustomerOrganizationsCFManager customerOrganizationsCFManager;
    private final RequestFeedbackCFManager requestFeedbackCFManager;
    private final RequestFeedbackDateCFManager requestFeedbackDateCFManager;
    private final ServiceDeskSecurityTypeInstaller serviceDeskSecurityTypeInstaller;
    private final ServiceDeskRoleCreation serviceDeskRoleCreation;
    private final InvariantModuleTracker invariantModuleTracker;
    private final EventListenerLauncher eventListenerLauncher;
    private final TimedPromiseStartupTaskRegistrar timedPromiseStartupTaskRegistrar;
    private final AutoWatchHandlerPatcher autoWatchHandlerPatcher;
    private final FeatureManager featureManager;
    private final QueueServiceOffThreadRegistration queueServiceOffThreadRegistration;

    @Autowired
    public PluginInitializer(PluginEventManager pluginEventManager, EventPublisher eventPublisher, VpOriginCustomFieldService vpOriginCustomFieldService, ParticipantsCustomFieldManager participantsCustomFieldManager, CustomerOrganizationsCFManager customerOrganizationsCFManager, RequestFeedbackCFManager requestFeedbackCFManager, RequestFeedbackDateCFManager requestFeedbackDateCFManager, ServiceDeskSecurityTypeInstaller serviceDeskSecurityTypeInstaller, ServiceDeskRoleCreation serviceDeskRoleCreation, InvariantModuleTracker invariantModuleTracker, EventListenerLauncher eventListenerLauncher, TimedPromiseStartupTaskRegistrar timedPromiseStartupTaskRegistrar, AutoWatchHandlerPatcher autoWatchHandlerPatcher, FeatureManager featureManager, QueueServiceOffThreadRegistration queueServiceOffThreadRegistration) {
        this.pluginEventManager = pluginEventManager;
        this.eventPublisher = eventPublisher;
        this.vpOriginCustomFieldService = vpOriginCustomFieldService;
        this.participantsCustomFieldManager = participantsCustomFieldManager;
        this.customerOrganizationsCFManager = customerOrganizationsCFManager;
        this.requestFeedbackCFManager = requestFeedbackCFManager;
        this.requestFeedbackDateCFManager = requestFeedbackDateCFManager;
        this.serviceDeskSecurityTypeInstaller = serviceDeskSecurityTypeInstaller;
        this.serviceDeskRoleCreation = serviceDeskRoleCreation;
        this.invariantModuleTracker = invariantModuleTracker;
        this.eventListenerLauncher = eventListenerLauncher;
        this.timedPromiseStartupTaskRegistrar = timedPromiseStartupTaskRegistrar;
        this.autoWatchHandlerPatcher = autoWatchHandlerPatcher;
        this.featureManager = featureManager;
        this.queueServiceOffThreadRegistration = queueServiceOffThreadRegistration;
    }

    public void initialize() {
        log.info((Object)"Registering event listeners...");
        this.eventPublisher.register((Object)this.eventListenerLauncher);
        this.pluginEventManager.register((Object)this.invariantModuleTracker);
        log.info((Object)"Adding customer fields support...");
        this.createVpOriginCustomField();
        log.info((Object)"Adding Service Desk Request Participants custom field...");
        this.createRequestParticipantsCustomField();
        if (this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_GROUP_PARTICIPANTS)) {
            log.info((Object)"Adding Service Desk customer organisations custom field...");
            this.createCustomerOrganizationsCustomField();
        }
        log.info((Object)"Adding Request Feedback custom field...");
        this.createRequestFeedbackCustomField();
        log.info((Object)"Adding Request Feedback Date custom field...");
        this.createRequestFeedbackDateCustomField();
        log.info((Object)"Adding auto watch handler...");
        this.autoWatchHandlerPatcher.install();
        log.info((Object)"Adding security type...");
        this.serviceDeskSecurityTypeInstaller.install();
        log.info((Object)"Adding project roles...");
        this.serviceDeskRoleCreation.createServiceDeskRoles();
        log.info((Object)"Attempt to register timed promise task runners...");
        this.timedPromiseStartupTaskRegistrar.registerTimedPromiseTaskRunners();
        log.info((Object)"Attempt to register off thread queue service runner...");
        this.queueServiceOffThreadRegistration.register();
    }

    private void createVpOriginCustomField() {
        this.vpOriginCustomFieldService.getVpOriginCustomField();
    }

    private void createRequestParticipantsCustomField() {
        this.participantsCustomFieldManager.getParticipantsCustomField();
    }

    private void createCustomerOrganizationsCustomField() {
        this.customerOrganizationsCFManager.getOrCreateOrganizationsCF();
    }

    private void createRequestFeedbackCustomField() {
        Option customField = this.requestFeedbackCFManager.getOrCreateRequestFeedbackCF();
        if (customField.isEmpty()) {
            log.error((Object)"Failed to retrieve the Request feedback custom field");
        }
    }

    private void createRequestFeedbackDateCustomField() {
        Option requestFeedbackDateCF = this.requestFeedbackDateCFManager.getOrCreateRequestFeedbackDateCF();
        if (requestFeedbackDateCF.isEmpty()) {
            log.error((Object)"Failed to retrieve the Service Desk Request Feedback Date custom field");
        }
    }

    public void uninitialize() {
        log.info((Object)"Unregistering event listeners...");
        this.pluginEventManager.unregister((Object)this.invariantModuleTracker);
        this.eventPublisher.unregister((Object)this.eventListenerLauncher);
        log.info((Object)"Unregistering auto watch handler...");
        this.autoWatchHandlerPatcher.uninstall();
        log.info((Object)"Removing security type...");
        this.serviceDeskSecurityTypeInstaller.uninstall();
        log.info((Object)"Attempt to un-register timed promise task runners...");
        this.timedPromiseStartupTaskRegistrar.unregisterTimedPromiseTaskRunners();
        log.info((Object)"Attempt to un-register off thread queue service runner...");
        this.queueServiceOffThreadRegistration.unregister();
    }
}

