/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.bootstrap.lifecycle.analytic;

import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.servicedesk.bootstrap.lifecycle.analytic.ServiceDeskStateAnalyticRunner;
import java.util.Date;
import java.util.Random;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ServiceDeskStateAnalyticScheduler {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceDeskStateAnalyticScheduler.class);
    private static final Random RNG = new Random();
    private final SchedulerService schedulerService;
    private final ServiceDeskStateAnalyticRunner serviceDeskStateAnalyticRunner;

    @Autowired
    public ServiceDeskStateAnalyticScheduler(SchedulerService schedulerService, ServiceDeskStateAnalyticRunner serviceDeskStateAnalyticRunner) {
        this.schedulerService = schedulerService;
        this.serviceDeskStateAnalyticRunner = serviceDeskStateAnalyticRunner;
    }

    public void registerScheduler() {
        LOG.info("Registering Service Desk state analytics scheduler");
        this.schedulerService.registerJobRunner(ServiceDeskStateAnalyticRunner.JOB_RUNNER_KEY, (JobRunner)this.serviceDeskStateAnalyticRunner);
    }

    public void startScheduler() {
        Date currentDate = DateTime.now().toDate();
        LOG.info("Starting Service Desk state analytics scheduler");
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)ServiceDeskStateAnalyticRunner.JOB_RUNNER_KEY).withSchedule(Schedule.forInterval((long)this.getJitteredIntervalTime(), (Date)currentDate)).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER);
        try {
            this.schedulerService.scheduleJob(ServiceDeskStateAnalyticRunner.JOB_ID, jobConfig);
        }
        catch (SchedulerServiceException e) {
            LOG.error("Failed to start Service Desk state analytics scheduler", (Throwable)e);
        }
        LOG.info("Started Service Desk state analytics scheduler");
    }

    public void stopScheduler() {
        LOG.info("Stopping Service Desk state analytics scheduler");
        this.schedulerService.unscheduleJob(ServiceDeskStateAnalyticRunner.JOB_ID);
    }

    public void unregisterScheduler() {
        LOG.info("Unregistering Service Desk state analytics scheduler");
        this.schedulerService.unregisterJobRunner(ServiceDeskStateAnalyticRunner.JOB_RUNNER_KEY);
    }

    private int getJitteredIntervalTime() {
        int jitter = RNG.nextInt() % 1800000;
        return 43200000 + jitter;
    }
}

