/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.bootstrap.lifecycle.analytic;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.application.confluence.ConfluenceApplicationType;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.servicedesk.internal.api.ServiceDeskManager;
import com.atlassian.servicedesk.internal.api.analytics.AnalyticsEvent;
import com.atlassian.servicedesk.internal.api.analytics.AnalyticsService;
import com.atlassian.servicedesk.internal.confluenceknowledgebase.ConfluenceKnowledgeBaseManager;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetricManager;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ServiceDeskStateAnalyticRunner
implements JobRunner {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceDeskStateAnalyticRunner.class);
    private static final String ASYNC_UPGRADE_KEY = "sd.state.analytic.scheduler.runner.key";
    public static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)"sd.state.analytic.scheduler.runner.key");
    public static final JobId JOB_ID = JobId.of((String)"sd.state.analytic.scheduler.runner.key");
    private final AnalyticsService analyticsService;
    private final ConfluenceKnowledgeBaseManager confluenceKnowledgeBaseManager;
    private final ServiceDeskManager serviceDeskManager;
    private final ApplicationLinkService applicationLinkService;
    private final TimeMetricManager timeMetricManager;

    @Autowired
    public ServiceDeskStateAnalyticRunner(AnalyticsService analyticsService, ConfluenceKnowledgeBaseManager confluenceKnowledgeBaseManager, ServiceDeskManager serviceDeskManager, ApplicationLinkService applicationLinkService, TimeMetricManager timeMetricManager) {
        this.analyticsService = analyticsService;
        this.confluenceKnowledgeBaseManager = confluenceKnowledgeBaseManager;
        this.serviceDeskManager = serviceDeskManager;
        this.applicationLinkService = applicationLinkService;
        this.timeMetricManager = timeMetricManager;
    }

    @Nullable
    public JobRunnerResponse runJob(JobRunnerRequest request) {
        try {
            int kbLinkedCount = this.confluenceKnowledgeBaseManager.getAllKbLinks().size();
            int serviceDesksCount = this.serviceDeskManager.getAllServiceDesks().size();
            long numberOfConfiguredSlaTimeMetrics = this.timeMetricManager.getTotalNumberOfConfiguredSlaTimeMetrics();
            List<ApplicationLink> confluenceApplicationLinks = this.getConfluenceApplicationLinks();
            boolean hasConfluenceSystemAppLink = confluenceApplicationLinks.stream().anyMatch(confluenceAppLink -> confluenceAppLink.isSystem());
            ServiceDeskStateAnalyticEvent serviceDeskStateAnalyticEvent = new ServiceDeskStateAnalyticEvent(serviceDesksCount, kbLinkedCount, confluenceApplicationLinks.size(), numberOfConfiguredSlaTimeMetrics, hasConfluenceSystemAppLink);
            this.analyticsService.fireAnalyticsEvent((AnalyticsEvent)serviceDeskStateAnalyticEvent);
        }
        catch (Exception e) {
            LOG.error("Failed to fire Service Desk state analytic event", (Throwable)e);
            return JobRunnerResponse.failed((String)"Failed to fire Service Desk state analytic event");
        }
        return JobRunnerResponse.success();
    }

    private List<ApplicationLink> getConfluenceApplicationLinks() {
        ArrayList applicationLinks = Lists.newArrayList((Iterable)this.applicationLinkService.getApplicationLinks());
        return applicationLinks.stream().filter(applink -> applink.getType() instanceof ConfluenceApplicationType).collect(Collectors.toList());
    }

    @EventName(value="servicedesk.state.scheduled.report")
    public static class ServiceDeskStateAnalyticEvent
    extends AnalyticsEvent {
        private final int numberOfServiceDesks;
        private final int numberOfKbLinked;
        private final int numberOfConfluenceAppLink;
        private final long numberOfConfiguredSlaTimeMetrics;
        private final boolean hasConfluenceSystemAppLink;

        public ServiceDeskStateAnalyticEvent(int numberOfServiceDesks, int numberOfKbLinked, int numberOfConfluenceAppLink, long numberOfConfiguredSlaTimeMetrics, boolean hasConfluenceSystemAppLink) {
            this.numberOfServiceDesks = numberOfServiceDesks;
            this.numberOfKbLinked = numberOfKbLinked;
            this.numberOfConfluenceAppLink = numberOfConfluenceAppLink;
            this.numberOfConfiguredSlaTimeMetrics = numberOfConfiguredSlaTimeMetrics;
            this.hasConfluenceSystemAppLink = hasConfluenceSystemAppLink;
        }

        public int getNumberOfServiceDesks() {
            return this.numberOfServiceDesks;
        }

        public int getNumberOfKbLinked() {
            return this.numberOfKbLinked;
        }

        public int getNumberOfConfluenceAppLink() {
            return this.numberOfConfluenceAppLink;
        }

        public boolean getHasConfluenceSystemAppLink() {
            return this.hasConfluenceSystemAppLink;
        }

        public long getNumberOfConfiguredSlaTimeMetrics() {
            return this.numberOfConfiguredSlaTimeMetrics;
        }
    }
}

