/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.bootstrap.lifecycle;

import io.atlassian.fugue.Option;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class LifecycleLock {
    private static Logger log = Logger.getLogger(LifecycleLock.class);
    private static final int MAX_WAIT_SECS = 5;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final AtomicBoolean running = new AtomicBoolean(false);

    public boolean isRunning() {
        return this.running.get();
    }

    public boolean setRunning(boolean flag) {
        return this.running.getAndSet(flag);
    }

    public <T> Callable<Option<T>> withPluginLifecycleSafety(Callable<T> callable) {
        return () -> {
            Object result = null;
            if (this.lock.readLock().tryLock()) {
                try {
                    if (!this.running.get()) return Option.option(result);
                    result = callable.call();
                    return Option.option(result);
                }
                finally {
                    if (this.lock.getReadHoldCount() > 0) {
                        this.lock.readLock().unlock();
                    }
                }
            } else {
                log.warn((Object)("Failed to acquire lifecycle read lock, callable won't be executed: " + callable.getClass().getCanonicalName()));
            }
            return Option.option(result);
        };
    }

    public void runOnStartup(Runnable runnable) throws IllegalStateException {
        this.writeImpl(runnable, true);
    }

    public void runOnShutdown(Runnable runnable) throws IllegalStateException {
        this.writeImpl(runnable, false);
    }

    private void writeImpl(Runnable runnable, boolean towardsRunning) {
        while (this.lock.getReadHoldCount() > 0) {
            this.lock.readLock().unlock();
        }
        try {
            if (this.lock.writeLock().tryLock(5L, TimeUnit.SECONDS)) {
                try {
                    runnable.run();
                    this.running.set(towardsRunning);
                    return;
                }
                finally {
                    this.lock.writeLock().unlock();
                }
            }
            throw new IllegalStateException(String.format("Unable to obtain the lifecycle lock.  An in-flight request is taking longer than %d seconds to complete", 5));
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Unable to obtain the lifecycle lock.  This thread has been interrupted while trying to get it", e);
        }
    }
}

