/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.bootstrap.info;

import com.atlassian.fugue.Option;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.version.JiraVersionService;
import com.atlassian.pocketknife.api.version.SoftwareVersion;
import com.atlassian.pocketknife.api.version.VersionKit;
import com.atlassian.servicedesk.api.info.PublicSoftwareInfo;
import com.atlassian.servicedesk.api.info.RestrictedSoftwareInfo;
import com.atlassian.servicedesk.api.info.ServiceDeskSoftwareInfoService;
import com.atlassian.servicedesk.api.info.Version;
import com.atlassian.servicedesk.bootstrap.info.VersionImpl;
import com.atlassian.servicedesk.bootstrap.version.BuildProperties;
import com.atlassian.servicedesk.internal.api.license.ServiceDeskApplicationLicenseService;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class ServiceDeskSoftwareInfoServiceImpl
implements ServiceDeskSoftwareInfoService {
    private final BuildProperties buildProperties;
    private final GlobalPermissionManager globalPermissionManager;
    private final JiraVersionService jiraVersionService;
    private final ServiceDeskApplicationLicenseService serviceDeskApplicationLicenseService;

    @Autowired
    public ServiceDeskSoftwareInfoServiceImpl(BuildProperties buildProperties, GlobalPermissionManager globalPermissionManager, JiraVersionService jiraVersionService, ServiceDeskApplicationLicenseService serviceDeskApplicationLicenseService) {
        this.buildProperties = buildProperties;
        this.globalPermissionManager = globalPermissionManager;
        this.jiraVersionService = jiraVersionService;
        this.serviceDeskApplicationLicenseService = serviceDeskApplicationLicenseService;
    }

    public PublicSoftwareInfo getSoftwareInfo(ApplicationUser user) {
        final Option<RestrictedSoftwareInfo> restrictedInfo = this.buildRestrictedInfo(user);
        return new PublicSoftwareInfo(){

            public Version getVersion() {
                return ServiceDeskSoftwareInfoServiceImpl.this.toVersion(ServiceDeskSoftwareInfoServiceImpl.this.buildProperties.getVersion());
            }

            public Version getPlatformVersion() {
                return ServiceDeskSoftwareInfoServiceImpl.this.toVersion(ServiceDeskSoftwareInfoServiceImpl.this.jiraVersionService.version());
            }

            public DateTime getBuildDate() {
                return ServiceDeskSoftwareInfoServiceImpl.this.buildProperties.getBuildDate();
            }

            public String getBuildChangeSet() {
                return (String)Option.option((Object)ServiceDeskSoftwareInfoServiceImpl.this.buildProperties.getChangeSet()).getOrElse((Object)"Unknown");
            }

            public boolean isLicensedForUse() {
                return ServiceDeskSoftwareInfoServiceImpl.this.serviceDeskApplicationLicenseService.isLicenseValid();
            }

            public Option<RestrictedSoftwareInfo> getRestrictedInfo() {
                return restrictedInfo;
            }
        };
    }

    private Version toVersion(String version) {
        SoftwareVersion v = VersionKit.parse((String)version);
        return this.toVersion(v);
    }

    private Version toVersion(SoftwareVersion v) {
        return new VersionImpl(v);
    }

    private Option<RestrictedSoftwareInfo> buildRestrictedInfo(ApplicationUser user) {
        if (this.has(GlobalPermissionKey.ADMINISTER, user) || this.has(GlobalPermissionKey.SYSTEM_ADMIN, user)) {
            RestrictedSoftwareInfo restrictedSoftwareInfo = new RestrictedSoftwareInfo(){};
            return Option.some((Object)restrictedSoftwareInfo);
        }
        return Option.none();
    }

    private boolean has(GlobalPermissionKey globalPermissionKey, ApplicationUser user) {
        return this.globalPermissionManager.hasPermission(globalPermissionKey, user);
    }
}

