/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.bootstrap.healthcheck;

import com.atlassian.healthcheck.core.Application;
import com.atlassian.healthcheck.core.HealthStatus;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.springframework.stereotype.Component;

@Component
public class ServiceDeskHealth {
    private volatile Exception aoAOK = null;
    private volatile Exception upgradeTasksAOK = null;
    private volatile Exception modulesStartedAOK = null;
    private volatile Exception upgradeVersionRequirementAOK = null;
    private volatile Exception asyncUpgradeScheduled = null;
    private volatile Throwable startupAOK = null;
    private volatile long checkTime = System.currentTimeMillis();
    private volatile boolean startedOk = true;

    public void clearHealthyState() {
        this.aoAOK = null;
        this.upgradeTasksAOK = null;
        this.modulesStartedAOK = null;
        this.upgradeVersionRequirementAOK = null;
        this.asyncUpgradeScheduled = null;
        this.startupAOK = null;
        this.startedOk = true;
        this.checkTime = System.currentTimeMillis();
    }

    public void clearHealthyStateOnStop() {
        this.clearHealthyState();
        this.setStartedOk(false);
    }

    public void setAoNotAOK(Exception aoAOK) {
        this.aoAOK = aoAOK;
        this.checkTime = System.currentTimeMillis();
    }

    public void setUpgradeTasksNotAOK(Exception e) {
        this.upgradeTasksAOK = e;
        this.checkTime = System.currentTimeMillis();
    }

    public void setModulesStartedNotAOK(Exception e) {
        this.modulesStartedAOK = e;
        this.checkTime = System.currentTimeMillis();
    }

    public void setUpgradeVersionRequirementAOK(Exception upgradeVersionRequirementAOK) {
        this.upgradeVersionRequirementAOK = upgradeVersionRequirementAOK;
        this.checkTime = System.currentTimeMillis();
    }

    public void setAsyncUpgradeScheduledNotAOK(Exception e) {
        this.asyncUpgradeScheduled = e;
        this.checkTime = System.currentTimeMillis();
    }

    public void setStartupNotAOK(Throwable t) {
        this.setStartedOk(false);
        this.startupAOK = t;
        this.checkTime = System.currentTimeMillis();
    }

    public boolean isStartedOk() {
        return this.startedOk;
    }

    public void setStartedOk(boolean startedOk) {
        this.startedOk = startedOk;
        this.checkTime = System.currentTimeMillis();
    }

    public Exception getAoAOK() {
        return this.aoAOK;
    }

    public Exception getUpgradeTasksAOK() {
        return this.upgradeTasksAOK;
    }

    public Exception getModulesStartedAOK() {
        return this.modulesStartedAOK;
    }

    public Exception getAsyncUpgradeScheduledAOK() {
        return this.asyncUpgradeScheduled;
    }

    public Throwable getStartupAOK() {
        return this.startupAOK;
    }

    public long getCheckTime() {
        return this.checkTime;
    }

    public HealthStatus getHealthStatus() {
        StringBuilder errors = new StringBuilder();
        if (this.upgradeVersionRequirementAOK != null) {
            errors.append(this.formatException("Version requirement for upgrade is not satisfied", this.upgradeVersionRequirementAOK));
        }
        if (this.aoAOK != null) {
            errors.append(this.formatException("Active Objects has failed to start", this.aoAOK));
        }
        if (this.upgradeTasksAOK != null) {
            errors.append(this.formatException("Upgrade Tasks have failed to run", this.upgradeTasksAOK));
        }
        if (this.modulesStartedAOK != null) {
            errors.append(this.formatException("The internal modules have failed to start", this.modulesStartedAOK));
        }
        if (this.asyncUpgradeScheduled != null) {
            errors.append(this.formatException("Service Desk async upgrade tasks have not been scheduled", this.asyncUpgradeScheduled));
        }
        if (this.startupAOK != null) {
            errors.append(this.formatException("Service Desk startup has had an unexpected problem. This needs to be investigated ASAP.", this.startupAOK));
        }
        return new HealthStatusImpl("JIRA Service Desk", "General Health Check", errors.length() == 0, errors.toString(), Application.Plugin, this.checkTime);
    }

    private String formatException(String message, Throwable exception) {
        return String.format("%s : %s \n %s", message, ExceptionUtils.getMessage((Throwable)exception), ExceptionUtils.getFullStackTrace((Throwable)exception));
    }

    private static class HealthStatusImpl
    implements HealthStatus {
        private final String name;
        private final String description;
        private final boolean healthy;
        private final String failureReason;
        private final Application application;
        private final long time;

        public HealthStatusImpl(String name, String description, boolean healthy, String failureReason, Application application, long checkTime) {
            this.name = name;
            this.description = description;
            this.healthy = healthy;
            this.failureReason = failureReason;
            this.application = application;
            this.time = checkTime;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean isHealthy() {
            return this.healthy;
        }

        public String failureReason() {
            return this.failureReason;
        }

        public Application getApplication() {
            return this.application;
        }

        public long getTime() {
            return this.time;
        }
    }
}

