/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pocketknife.internal.tracker;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginController;
import com.atlassian.plugin.PluginState;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.events.PluginDisablingEvent;
import com.atlassian.plugin.event.events.PluginModuleDisabledEvent;
import com.atlassian.pocketknife.api.tracker.InvariantModuleTracker;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InvariantModuleTrackerImpl
implements InvariantModuleTracker {
    private static final Logger log = LoggerFactory.getLogger(InvariantModuleTrackerImpl.class);
    private final Set<InvariantModuleTracker.Module> invariantModules = Sets.newHashSet();
    private final PluginController pluginController;

    @Autowired
    public InvariantModuleTrackerImpl(PluginController pluginController) {
        this.pluginController = pluginController;
    }

    @Override
    public void addInvariant(InvariantModuleTracker.Module module) {
        this.invariantModules.add(module);
    }

    @PluginEventListener
    public void onPluginDisabling(PluginDisablingEvent pluginDisablingEvent) {
        String disablingPluginKey = pluginDisablingEvent.getPlugin().getKey();
        Iterator<InvariantModuleTracker.Module> it = this.invariantModules.iterator();
        while (it.hasNext()) {
            InvariantModuleTracker.Module module = it.next();
            if (!module.getPluginKey().equals(disablingPluginKey)) continue;
            log.debug("Unregistering invariant module " + module.getModuleKey() + " as plugin " + disablingPluginKey + " is being disabled.");
            it.remove();
        }
    }

    @PluginEventListener
    public void onModuleDisabled(PluginModuleDisabledEvent pluginModuleDisabledEvent) {
        ModuleDescriptor moduleDescriptor = pluginModuleDisabledEvent.getModule();
        InvariantModuleTracker.Module module = new InvariantModuleTracker.Module(moduleDescriptor.getPluginKey(), moduleDescriptor.getKey());
        if (this.invariantModules.contains(module) && moduleDescriptor.getPlugin().getPluginState() != PluginState.DISABLING) {
            log.warn("The module " + module.getModuleKey() + " is required by the plugin " + moduleDescriptor.getPlugin().getName() + " and can't be disabled");
            this.pluginController.enablePluginModule(moduleDescriptor.getCompleteKey());
        }
    }
}

