/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pocketknife.internal.logging;

import com.atlassian.pocketknife.api.logging.SupportInfo;
import com.atlassian.pocketknife.api.upgrade.PluginRunInfo;
import com.atlassian.pocketknife.api.upgrade.UpgradeHistoryDetail;
import com.atlassian.pocketknife.api.upgrade.UpgradeVersionService;
import com.atlassian.pocketknife.spi.info.PocketKnifePluginInfo;
import com.atlassian.pocketknife.spi.logging.PocketKnifeLoggingInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SupportInfoImpl
implements SupportInfo {
    private static final String STARTED = "started";
    private static final String ENDED = "ended";
    @Autowired
    private UpgradeVersionService upgradeVersionService;
    @Autowired
    PocketKnifePluginInfo pocketKnifePluginInfo;
    @Autowired
    PocketKnifeLoggingInfo pocketKnifeLoggingInfo;

    private Logger log() {
        Logger log = Logger.getLogger((String)this.pocketKnifeLoggingInfo.getStartupLoggerName());
        log.setLevel(Level.INFO);
        return log;
    }

    @Override
    public void logSupportInfoOnStartup() {
        this.showPluginRunHistory();
    }

    private String getProductName() {
        return this.pocketKnifePluginInfo.getProductName();
    }

    private void showPluginRunHistory() {
        int index;
        Logger log = this.log();
        List pluginRunHistory = this.upgradeVersionService.getPluginRunHistory();
        if (pluginRunHistory.isEmpty()) {
            log.info((Object)("There does not appear to be any " + this.getProductName() + " run history"));
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\n\n" + this.getProductName() + " Run History\n");
        String lastVersion = "";
        ArrayList toShow = Lists.newArrayList();
        for (PluginRunInfo runInfo : pluginRunHistory) {
            if (!lastVersion.contains("-SNAPSHOT") || !lastVersion.equals(runInfo.getPreviousVersion())) {
                toShow.add(runInfo);
            }
            lastVersion = runInfo.getPreviousVersion();
        }
        for (int i = index = Math.max(toShow.size() - 10, 0); i < toShow.size(); ++i) {
            PluginRunInfo runInfo = (PluginRunInfo)toShow.get(i);
            sb.append("\n").append("\t").append(i == pluginRunHistory.size() - 1 ? "*" : "").append(this.getProductName() + " v").append(runInfo.getPreviousVersion()).append(" (").append(runInfo.getPreviousChangeSet()).append(")").append(" started at ").append(runInfo.getRanOnStr()).append("\n");
        }
        sb.append("\n");
        log.info((Object)sb.toString());
    }

    @Override
    public void showUpgradeTaskHistory() {
        Logger log = this.log();
        List upgradeHistory = this.upgradeVersionService.getUpgradeHistory();
        if (upgradeHistory.isEmpty()) {
            log.info((Object)("There does not appear to be any " + this.getProductName() + " upgrade history"));
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\n\nThe following " + this.getProductName() + " upgrade tasks have been run on this system\n");
        for (UpgradeHistoryDetail detail : upgradeHistory) {
            String startedOrEnded = detail.isStartRecord() ? StringUtils.rightPad((String)STARTED, (int)STARTED.length()) : StringUtils.rightPad((String)ENDED, (int)STARTED.length());
            sb.append("\n").append("\tUpgradeTask ").append(StringUtils.leftPad((String)detail.getBuildNumber(), (int)3)).append(" ").append(startedOrEnded).append(" at ").append(detail.getRanOnStr()).append(" within v").append(detail.getPluginVersion()).append(" (").append(detail.getChangeSet()).append(")");
            if (!StringUtils.isNotBlank((String)detail.getTimeTaken())) continue;
            sb.append(" and took ").append(detail.getTimeTaken()).append(" ms");
        }
        sb.append("\n");
        log.info((Object)sb.toString());
    }
}

