/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pocketknife.internal.customfields.query;

import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.query.QueryFactoryResult;
import com.atlassian.pocketknife.internal.customfields.query.JSDOperatorSpecificQueryFactory;
import com.atlassian.pocketknife.internal.customfields.query.JSDRangeQueryFactory;
import com.atlassian.pocketknife.internal.customfields.util.IndexValuesConverter;
import com.atlassian.query.operator.Operator;
import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSDActualValueRelationalQueryFactory
implements JSDOperatorSpecificQueryFactory {
    private static final Logger log = LoggerFactory.getLogger(JSDActualValueRelationalQueryFactory.class);
    private static final JSDRangeQueryFactory<String> RANGE_QUERY_FACTORY = JSDRangeQueryFactory.stringRangeQueryFactory();
    private final IndexValuesConverter indexValuesConverter;
    private final String emptyIndexValue;

    public JSDActualValueRelationalQueryFactory(IndexValuesConverter indexValuesConverter) {
        this(indexValuesConverter, null);
    }

    public JSDActualValueRelationalQueryFactory(IndexValuesConverter indexValuesConverter, String emptyIndexValue) {
        this.indexValuesConverter = indexValuesConverter;
        this.emptyIndexValue = emptyIndexValue;
    }

    @Override
    public QueryFactoryResult createQueryForSingleValue(QueryCreationContext queryCreationContext, String fieldName, Operator operator, List<QueryLiteral> rawValues) {
        if (!this.handlesOperator(operator)) {
            log.debug(String.format("ActualValueRelationalQueryFactory does not support operator '%s'.", operator.getDisplayString()));
            return QueryFactoryResult.createFalseResult();
        }
        List<String> values2 = this.indexValuesConverter.getIndexValues(queryCreationContext, rawValues);
        if (values2.isEmpty()) {
            return QueryFactoryResult.createFalseResult();
        }
        String value = values2.get(0);
        if (value == null) {
            log.debug("Relation operators do not support empty values");
            return QueryFactoryResult.createFalseResult();
        }
        Query query = RANGE_QUERY_FACTORY.get(operator, fieldName, value);
        if (this.emptyIndexValue != null) {
            BooleanQuery combined = new BooleanQuery();
            combined.add(query, BooleanClause.Occur.MUST);
            combined.add((Query)new TermQuery(new Term(fieldName, this.emptyIndexValue)), BooleanClause.Occur.MUST_NOT);
            query = combined;
        }
        return new QueryFactoryResult(query);
    }

    @Override
    public QueryFactoryResult createQueryForMultipleValues(QueryCreationContext queryCreationContext, String fieldName, Operator operator, List<QueryLiteral> rawValues) {
        log.debug("Relation operators do not support multivalue operands");
        return QueryFactoryResult.createFalseResult();
    }

    @Override
    public QueryFactoryResult createQueryForEmptyOperand(QueryCreationContext queryCreationContext, String fieldName, Operator operator) {
        log.debug("Relation operators do not support multivalue empty");
        return QueryFactoryResult.createFalseResult();
    }

    @Override
    public boolean handlesOperator(Operator operator) {
        return OperatorClasses.RELATIONAL_ONLY_OPERATORS.contains(operator);
    }
}

