/* globals define, JIRA */
define("JEP/Jira/trace", [], function () {
    // Internally AMD is an object of names to references. If we tried to do return JIRA.trace from this module AMD
    // would store a reference to w/e JIRA.trace is currently pointed at. This is a problem if something else comes
    // along and refined JIRA.trace to something else. AMD would maintain a reference to the old value of JIRA.trace.
    // This wrapper function ensures we always refer to the current definition of JIRA.trace and not a stale reference.

    return function() {
        if(window.JIRA && window.JIRA.trace) { // if JIRA.trace exists call it
            window.JIRA.trace.apply(this, arguments);
        }
        // otherwise noop
    };
});