/* global define */

/**
 * Show mail connection activity
 *    var mailLog = MailConnectivityLog.create({
 *          el : ".jep-mail-connectivity-log",
 *          channelKey : "CHANNEL",  // optional
 *          pageLimit : 50,          // optional
 *          currentPage : 1          // optional
 *       });
 *    mailLog.show();
 *
 * Note:
 *  - channelKey is the mail channel key from JIRA email processing plugin.
 *  - For this connectivity log, if mail channelKey is not provided, it would show logs from all channels.
 */

define("JEP/MailConnectivityLog", [
    "jquery",
    "underscore",
    "exports",
    "JEP/shared/Tracker",
    "JEP/MailLog",
    "JEP/MailConnectivityLogModel"
], function (
    $,
    _,
    Exports,
    Tracker,
    MailLog,
    ConnectivityLogModel
) {

    var View = MailLog.extend({

        template: JEP.Templates.Components.MailLog.connectivityLog,

        initialize: function (options) {

            // call super.initialize()
            MailLog.prototype.initialize.call(this, options);

            // initialize connectivity log model
            this.connectivityLogModel = new ConnectivityLogModel();

            this.listenTo(this.connectivityLogModel, this.connectivityLogModel.events.getConnectivityLogDone,
                _.bind(this._renderView, this));

            this.listenTo(this.connectivityLogModel, this.connectivityLogModel.events.getConnectivityLogFailed,
                _.bind(function (errorMessage) {
                    Tracker.trackPageview("/component/maillog/connectivity/error", {
                        "errorMessage" : errorMessage
                    });
                    this._renderError(errorMessage);
                }, this));
        },

        setChannelKey: function (channelKey) {
            this.channelKey = channelKey;
            return this;
        },

        setPageLimit: function (pageLimit) {
            this.pageLimit = pageLimit;
            return this;
        },

        setCurrentPage: function (currentPage) {
            this.currentPage = currentPage;
            return this;
        },

        show: function () {
            if (!this.hasShownBefore) {
                this.showWaitingPage();
            }
            this.hasShownBefore = true;

            if (this.channelKey) {
                Tracker.trackPageview("/component/maillog/connectivity/channel", {
                    "currentPage" : this.currentPage,
                    "totalPages" : this.connectivityLogModel.get("totalPages"),
                    "pageLimit" : this.pageLimit
                });
                this.connectivityLogModel.getConnectivityForChannel(this.channelKey, this.pageLimit, this.currentPage);
            } else {
                Tracker.trackPageview("/component/maillog/connectivity/global", {
                    "currentPage" : this.currentPage,
                    "totalPages" : this.connectivityLogModel.get("totalPages"),
                    "pageLimit" : this.pageLimit
                });
                this.connectivityLogModel.getConnectivity(this.pageLimit, this.currentPage);
            }

            return this;
        },

        _renderView: function () {
            var jsonModel = this.connectivityLogModel.toJSON();
            this.$el.html(this.template({
                connectivities: jsonModel.data
            }));

            this._renderPagination(this.currentPage, jsonModel.totalPages);
            this.trigger(this.events.renderCompleted, false);
        }
    });

    Exports.create = function (options) {
        return new View(options);
    };
});