/* globals define, AJS */
define("JEP/globalmail/GlobalMailSettingsModel", [
    "jquery",
    "underscore",
    "backbone",
    "JEP/shared/ajax",
    "JEP/shared/Tracker"
], function (
    $,
    _,
    Backbone,
    Ajax,
    Tracker
) {
    return Backbone.Model.extend({

        namedAttributes: {
            isPullerOn: Boolean,
            isProcessorOn: Boolean
        },

        url: {
            pullerOn: AJS.contextPath() + "/rest/jira-email-processor-plugin/1.0/mail/global/puller/on",
            pullerOff: AJS.contextPath() + "/rest/jira-email-processor-plugin/1.0/mail/global/puller/off",
            processorOn: AJS.contextPath() + "/rest/jira-email-processor-plugin/1.0/mail/global/processor/on",
            processorOff: AJS.contextPath() + "/rest/jira-email-processor-plugin/1.0/mail/global/processor/off",
            cleanerThreshold: AJS.contextPath() + "/rest/jira-email-processor-plugin/1.0/mail/global/cleaner"
        },

        turnPullerOn: function () {
            var deferred = $.Deferred();

            Ajax.put(this.url.pullerOn)
                .done(_.bind(function (isOn) {
                    Tracker.trackPageview("/admin/globalmailsettings/puller/on/success");
                    this.set("isPullerOn", isOn);
                    deferred.resolve(isOn);
                }, this))
                .fail(function (xhr) {
                    var errorMessage = Ajax.getErrorMessage(xhr);
                    Tracker.trackPageview("/admin/globalmailsettings/puller/on/failure", {"errorMessage" : errorMessage});
                    deferred.reject(errorMessage);
                });
            return deferred;
        },

        turnPullerOff: function () {
            var deferred = $.Deferred();

            Ajax.put(this.url.pullerOff)
                .done(_.bind(function (isOn) {
                    Tracker.trackPageview("/admin/globalmailsettings/puller/off/success");
                    this.set("isPullerOn", isOn);
                    deferred.resolve(isOn);
                }, this))
                .fail(function (xhr) {
                    var errorMessage = Ajax.getErrorMessage(xhr);
                    Tracker.trackPageview("/admin/globalmailsettings/puller/off/failure", {"errorMessage" : errorMessage});
                    deferred.reject(errorMessage);
                });
            return deferred;
        },

        turnProcessorOn: function () {
            var deferred = $.Deferred();

            Ajax.put(this.url.processorOn)
                .done(_.bind(function (isOn) {
                    Tracker.trackPageview("/admin/globalmailsettings/processor/on/success");
                    this.set("isProcessorOn", isOn);
                    deferred.resolve(isOn);
                }, this))
                .fail(function (xhr) {
                    var errorMessage = Ajax.getErrorMessage(xhr);
                    Tracker.trackPageview("/admin/globalmailsettings/processor/on/failure", {"errorMessage" : errorMessage});
                    deferred.reject(errorMessage);
                });
            return deferred;
        },

        turnProcessorOff: function () {
            var deferred = $.Deferred();

            Ajax.put(this.url.processorOff)
                .done(_.bind(function (isOn) {
                    Tracker.trackPageview("/admin/globalmailsettings/processor/off/success");
                    this.set("isProcessorOn", isOn);
                    deferred.resolve(isOn);
                }, this))
                .fail(function (xhr) {
                    var errorMessage = Ajax.getErrorMessage(xhr);
                    Tracker.trackPageview("/admin/globalmailsettings/processor/off/failure", {"errorMessage" : errorMessage});
                    deferred.reject(errorMessage);
                });
            return deferred;
        },

        setCleanerThreshold: function (age) {
            var deferred = $.Deferred();

            Ajax.put(this.url.cleanerThreshold, { threshold: age})
                .done(_.bind(function (setAge) {
                    Tracker.trackPageview("/admin/globalmailsettings/cleaner/threshold/set");
                    deferred.resolve(setAge);
                }, this))
                .fail(function (xhr) {
                    var errorMessage = Ajax.getErrorMessage(xhr);
                    Tracker.trackPageview("/admin/globalmailsettings/cleaner/threshold/failure", {"errorMessage" : errorMessage});
                    deferred.reject(errorMessage);
                });

            return deferred;
        }
    });
});