/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.internal.mail.processor.webwork;

import com.atlassian.jira.internal.mail.processor.util.MailLoggerFactory;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import io.atlassian.fugue.Option;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import webwork.action.ActionContext;

@WebSudoRequired
public class SoyActionSupport
extends JiraWebActionSupport {
    private static final Logger logger = MailLoggerFactory.getLogger();
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final PageBuilderService pageBuilderService;
    private static final String PLUGIN_KEY = "com.atlassian.jira.jira-email-processor-plugin";

    @Autowired
    public SoyActionSupport(SoyTemplateRenderer soyTemplateRenderer, PageBuilderService pageBuilderService) {
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.pageBuilderService = pageBuilderService;
    }

    public void renderSoy(String moduleKey, String templateName, Map<String, Object> params) {
        this.getResources(moduleKey);
        Option<Appendable> responseWriter = this.getResponseWriter();
        if (responseWriter.isDefined()) {
            try {
                this.soyTemplateRenderer.render((Appendable)responseWriter.get(), "com.atlassian.jira.jira-email-processor-plugin:" + moduleKey, templateName, params);
            }
            catch (SoyException ex) {
                logger.error(String.format("Cannot render soy template (%s:%s/%s)", PLUGIN_KEY, moduleKey, templateName), (Throwable)ex);
            }
        } else {
            logger.error("Could not obtain response writer.");
        }
    }

    private void getResources(String moduleKey) {
        this.pageBuilderService.assembler().resources().requireWebResource("com.atlassian.jira.jira-email-processor-plugin:" + moduleKey);
    }

    private Option<Appendable> getResponseWriter() {
        try {
            return Option.option((Object)ActionContext.getResponse().getWriter());
        }
        catch (IOException e) {
            logger.error("Unable to get response writer due to an error: {}", (Object)e.getMessage());
            return Option.none();
        }
        catch (RuntimeException e) {
            logger.error("Unable to get response writer due to an exception: ", (Throwable)e);
            return Option.none();
        }
    }
}

