/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.internal.mail.processor.visiblefortest;

import com.atlassian.jira.internal.mail.processor.feature.channel.MailChannelDTO;
import com.atlassian.jira.internal.mail.processor.feature.channel.MailChannelManager;
import com.atlassian.jira.internal.mail.processor.feature.cleaner.MailCleanerManager;
import com.atlassian.jira.internal.mail.processor.feature.connection.MailConnectionDTO;
import com.atlassian.jira.internal.mail.processor.feature.connection.MailConnectionManager;
import com.atlassian.jira.internal.mail.processor.feature.handler.MailHandlerManager;
import com.atlassian.jira.internal.mail.processor.feature.property.MailGlobalSettingManager;
import com.atlassian.jira.internal.mail.processor.feature.property.PropertySetProvider;
import com.atlassian.jira.internal.mail.processor.visiblefortest.MailSettingBackdoor;
import com.atlassian.jira.internal.mail.processor.visiblefortest.backdoorutils.DefaultMailLoopDetectionBackdoorAccessor;
import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.google.common.annotations.VisibleForTesting;
import io.atlassian.fugue.Option;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
@VisibleForTesting
public class MailSettingBackdoorImpl
implements MailSettingBackdoor {
    private final MailGlobalSettingManager mailGlobalSettingManager;
    private final MailConnectionManager mailConnectionManager;
    private final MailHandlerManager mailHandlerManager;
    private final MailChannelManager mailChannelManager;
    private final MailCleanerManager mailCleanerManager;
    private final PropertySetProvider propertySetProvider;
    private final DefaultMailLoopDetectionBackdoorAccessor defaultMailLoopDetectionBackdoorAccessor;

    @Autowired
    public MailSettingBackdoorImpl(MailGlobalSettingManager mailGlobalSettingManager, MailConnectionManager mailConnectionManager, MailHandlerManager mailHandlerManager, MailChannelManager mailChannelManager, MailCleanerManager mailCleanerManager, PropertySetProvider propertySetProvider, DefaultMailLoopDetectionBackdoorAccessor defaultMailLoopDetectionBackdoorAccessor) {
        this.mailGlobalSettingManager = mailGlobalSettingManager;
        this.mailConnectionManager = mailConnectionManager;
        this.mailHandlerManager = mailHandlerManager;
        this.mailChannelManager = mailChannelManager;
        this.mailCleanerManager = mailCleanerManager;
        this.propertySetProvider = propertySetProvider;
        this.defaultMailLoopDetectionBackdoorAccessor = defaultMailLoopDetectionBackdoorAccessor;
    }

    @Override
    public int createMailConnection(String host, int port, String protocol, String username, String password, String email, String folder, boolean tls, long pullDate) {
        MailConnectionDTO mailConnectionDTO = new MailConnectionDTO(0, host, port, protocol, username, password, email, folder, tls, pullDate, 60000L);
        return ((MailConnectionDTO)this.mailConnectionManager.createMailConnection(Option.none(), mailConnectionDTO).right().get()).getId();
    }

    @Override
    public void clearData() {
        this.mailCleanerManager.cleanUpItemsBefore(System.currentTimeMillis());
        for (MailChannelDTO mailChannelDTO : this.mailChannelManager.getMailChannels()) {
            this.mailHandlerManager.deleteMailHandlerByChannel(Option.none(), mailChannelDTO);
            this.mailChannelManager.deleteMailChannel(Option.none(), mailChannelDTO);
        }
        for (MailConnectionDTO mailConnectionDTO : this.mailConnectionManager.getMailConnections()) {
            this.mailConnectionManager.deleteMailConnection(Option.none(), mailConnectionDTO);
        }
    }

    @Override
    public JSONArray getMailConnections() {
        List mailConnections = this.mailConnectionManager.getMailConnections();
        JSONArray jsonArray = new JSONArray();
        try {
            for (MailConnectionDTO mailConnection : mailConnections) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("id", mailConnection.getId());
                jsonObject.put("emailaddress", (Object)mailConnection.getEmailAddress());
                jsonObject.put("hostname", (Object)mailConnection.getHostName());
                jsonObject.put("username", (Object)mailConnection.getUserName());
                jsonArray.put((Object)jsonObject);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jsonArray;
    }

    @Override
    public long deleteMailConnection(int id) {
        Option mailConnectionOption = this.mailConnectionManager.getMailConnectionById(Option.none(), id);
        if (mailConnectionOption.isDefined()) {
            return this.mailConnectionManager.deleteMailConnection(Option.none(), (MailConnectionDTO)mailConnectionOption.get());
        }
        return -1L;
    }

    @Override
    public int setMaxMailPerPull(int maxMailPerPull) {
        this.mailGlobalSettingManager.setMaxMailPerPull(maxMailPerPull);
        return maxMailPerPull;
    }

    @Override
    public int setMailSizeLimit(int mailSizeLimit) {
        this.mailGlobalSettingManager.setMailSizeLimit(mailSizeLimit);
        return mailSizeLimit;
    }

    @Override
    public boolean setGlobalPullerJobState(boolean globalPullerState) {
        this.mailGlobalSettingManager.setGlobalPullerJobState(globalPullerState);
        return globalPullerState;
    }

    @Override
    public boolean setGlobalProcessorJobState(boolean globalProcessorState) {
        this.mailGlobalSettingManager.setGlobalProcessorJobState(globalProcessorState);
        return globalProcessorState;
    }

    @Override
    public boolean isGlobalPullerJobOn() {
        return this.mailGlobalSettingManager.isGlobalPullerJobOn();
    }

    @Override
    public boolean isGlobalProcessorJobOn() {
        return this.mailGlobalSettingManager.isGlobalProcessorJobOn();
    }

    @Override
    public void removeAllGlobalSettings() {
        this.propertySetProvider.globalSettingProperties().remove();
    }

    @Override
    public void setMailLoopThreshold(int threshold) {
        this.defaultMailLoopDetectionBackdoorAccessor.setCurrentThreshold(threshold);
    }
}

