/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.internal.mail.processor.rest.response.auditlog;

import com.atlassian.jira.internal.mail.processor.feature.audit.mailitem.MailItemAuditDTO;
import com.atlassian.jira.internal.mail.processor.feature.audit.mailrun.MailRunAuditDTO;
import com.atlassian.jira.internal.mail.processor.rest.response.auditlog.ConnectivityLogResponse;
import com.atlassian.jira.internal.mail.processor.rest.response.auditlog.ProcessingLogResponse;
import com.atlassian.jira.internal.mail.processor.util.DateFormatter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;

public class AuditLogTransformer {
    public static Collection<ProcessingLogResponse> buildProcessingLogResponse(DateFormatter dateFormatter, Collection<MailItemAuditDTO> mailItemAuditList) {
        ArrayList processingLog = Lists.newArrayList();
        for (MailItemAuditDTO mailRunAuditDTO : mailItemAuditList) {
            ProcessingLogResponse processingLogResponse = new ProcessingLogResponse(mailRunAuditDTO.getId(), mailRunAuditDTO.getMailChannelId(), mailRunAuditDTO.getMailItemId(), mailRunAuditDTO.getHandlerNameKey(), mailRunAuditDTO.getResultStatus(), mailRunAuditDTO.getMessage(), mailRunAuditDTO.getFromAddress(), mailRunAuditDTO.getMailChannelName(), mailRunAuditDTO.getSubject(), mailRunAuditDTO.getIssueKey(), mailRunAuditDTO.getNoOfRetry(), dateFormatter.timeAbsolute(mailRunAuditDTO.getCreatedTimestamp()), dateFormatter.timeAbsolute(mailRunAuditDTO.getUpdatedTimestamp()));
            processingLog.add(processingLogResponse);
        }
        return processingLog;
    }

    public static Collection<ConnectivityLogResponse> buildConnectivityLogResponse(DateFormatter dateFormatter, Collection<MailRunAuditDTO> mailRunAuditDTOCollection) {
        ArrayList connectivities = Lists.newArrayList();
        for (MailRunAuditDTO mailRunAuditDTO : mailRunAuditDTOCollection) {
            ConnectivityLogResponse connectivityLogResponse = new ConnectivityLogResponse(mailRunAuditDTO.getId(), mailRunAuditDTO.getMailConnectionId(), mailRunAuditDTO.getMailChannelName(), mailRunAuditDTO.getFailureMessage(), mailRunAuditDTO.getNoOfRetry(), mailRunAuditDTO.getRunOutcome().name(), dateFormatter.timeAbsolute(mailRunAuditDTO.getCreatedTimestamp()), dateFormatter.timeAbsolute(mailRunAuditDTO.getUpdatedTimestamp()));
            connectivities.add(connectivityLogResponse);
        }
        return connectivities;
    }
}

