/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.internal.mail.processor.rest;

import com.atlassian.jira.internal.mail.processor.feature.audit.MailAuditService;
import com.atlassian.jira.internal.mail.processor.feature.channel.MailChannelService;
import com.atlassian.jira.internal.mail.processor.feature.connection.MailConnectionService;
import com.atlassian.jira.internal.mail.processor.rest.MailBaseResource;
import com.atlassian.jira.internal.mail.processor.rest.response.ResponseBuilder;
import com.atlassian.jira.internal.mail.processor.util.DateFormatterFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;

public class MailAuditResource
extends MailBaseResource {
    private static long MAX_LIMIT = 1000L;
    private static long DEFAULT_LIMIT = 50L;
    protected final MailAuditService mailAuditService;
    protected final DateFormatterFactory dateFormatterFactory;
    protected final MailChannelService mailChannelService;
    protected final MailConnectionService mailConnectionService;

    public MailAuditResource(JiraAuthenticationContext authenticationContext, MailAuditService mailAuditService, ResponseBuilder responseBuilder, DateFormatterFactory dateFormatterFactory, MailChannelService mailChannelService, MailConnectionService mailConnectionService) {
        super(authenticationContext, responseBuilder);
        this.mailAuditService = mailAuditService;
        this.dateFormatterFactory = dateFormatterFactory;
        this.mailChannelService = mailChannelService;
        this.mailConnectionService = mailConnectionService;
    }

    protected long getOffset(long page, long limit) {
        return page > 1L ? (page - 1L) * limit : 0L;
    }

    protected long getSafeLimit(long limit) {
        if (limit == 0L) {
            return DEFAULT_LIMIT;
        }
        if (limit > MAX_LIMIT) {
            return MAX_LIMIT;
        }
        return limit;
    }
}

