/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.internal.mail.processor.rest;

import com.atlassian.jira.internal.mail.processor.rest.MailBaseResource;
import com.atlassian.jira.internal.mail.processor.rest.request.UpdateEmailCleanerAgeThresholdRequest;
import com.atlassian.jira.internal.mail.processor.rest.response.ResponseBuilder;
import com.atlassian.jira.internal.mail.processor.services.MailSettingService;
import com.atlassian.jira.security.JiraAuthenticationContext;
import io.atlassian.fugue.Either;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;

@Path(value="mail/global")
public class GlobalMailSettingsResource
extends MailBaseResource {
    private final MailSettingService mailSettingService;

    public GlobalMailSettingsResource(JiraAuthenticationContext authenticationContext, MailSettingService mailSettingService, ResponseBuilder responseBuilder) {
        super(authenticationContext, responseBuilder);
        this.mailSettingService = mailSettingService;
    }

    @PUT
    @Path(value="puller/on")
    public Response turnOnPuller() {
        Either result = this.mailSettingService.turnOnPuller(this.getCurrentUser());
        return this.responseBuilder.parse(result);
    }

    @PUT
    @Path(value="puller/off")
    public Response turnOffPuller() {
        Either result = this.mailSettingService.turnOffPuller(this.getCurrentUser());
        return this.responseBuilder.parse(result);
    }

    @PUT
    @Path(value="processor/on")
    public Response turnOnProcessor() {
        Either result = this.mailSettingService.turnOnProcessor(this.getCurrentUser());
        return this.responseBuilder.parse(result);
    }

    @PUT
    @Path(value="processor/off")
    public Response turnOffProcessor() {
        Either result = this.mailSettingService.turnOffProcessor(this.getCurrentUser());
        return this.responseBuilder.parse(result);
    }

    @PUT
    @Path(value="cleaner")
    public Response setEmailCleanerThresholdDays(UpdateEmailCleanerAgeThresholdRequest request) {
        Either result = this.mailSettingService.setEmailCleanerAgeThreshold(this.getCurrentUser(), request.getThreshold());
        return this.responseBuilder.parse(result);
    }
}

