/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.internal.mail.processor.handler;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.internal.mail.processor.descriptor.AbstractHandlerModuleDescriptor;
import com.atlassian.jira.internal.mail.processor.descriptor.ConnectionFailureHandlerModuleDescriptor;
import com.atlassian.jira.internal.mail.processor.descriptor.MailFilterModuleDescriptor;
import com.atlassian.jira.internal.mail.processor.descriptor.MailHandlerModuleDescriptor;
import com.atlassian.jira.internal.mail.processor.feature.handler.MailHandlerFactory;
import com.atlassian.jira.internal.mail.processor.feature.handler.MailHandlerWrapper;
import com.atlassian.jira.internal.mail.processor.util.MailLoggerFactory;
import com.atlassian.jira.mail.processor.spi.failhandler.ConnectionFailureHandler;
import com.atlassian.jira.mail.processor.spi.handler.MailFilter;
import com.atlassian.jira.mail.processor.spi.handler.MailHandler;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.annotations.VisibleForTesting;
import io.atlassian.fugue.Option;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MailHandlerFactoryImpl
implements MailHandlerFactory {
    private final Logger logger = MailLoggerFactory.getProcessorLogger();
    private final PluginAccessor pluginAccessor;

    @Autowired
    public MailHandlerFactoryImpl(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public Option<MailHandlerWrapper<MailFilter>> getMailFilterWrapper(String mailFilterModuleCompleteKey) {
        return this.getHandler(mailFilterModuleCompleteKey, MailFilterModuleDescriptor.class);
    }

    public Option<MailHandlerWrapper<MailHandler>> getMailHandlerWrapper(String mailHandlerModuleCompleteKey) {
        return this.getHandler(mailHandlerModuleCompleteKey, MailHandlerModuleDescriptor.class);
    }

    public boolean isMailHandlerActive(String mailHandlerModuleCompleteKey) {
        return this.getModuleDescriptor(mailHandlerModuleCompleteKey, MailHandlerModuleDescriptor.class).isDefined();
    }

    public Option<MailHandlerWrapper<ConnectionFailureHandler>> getConnectionFailureHandlerWrapper(String connectionFailHandlerModuleCompleteKey) {
        return this.getHandler(connectionFailHandlerModuleCompleteKey, ConnectionFailureHandlerModuleDescriptor.class);
    }

    @VisibleForTesting
    <T, K extends AbstractHandlerModuleDescriptor<T>> Option<K> getModuleDescriptor(String moduleCompleteKey, Class<K> clazz) {
        List descriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(clazz);
        Optional<AbstractHandlerModuleDescriptor> foundDescriptorOptional = descriptors.stream().filter(descriptor -> descriptor.getCompleteKey().equals(moduleCompleteKey)).filter(descriptor -> null == descriptor.getCondition() || descriptor.getCondition().shouldDisplay(new HashMap())).findFirst();
        if (foundDescriptorOptional.isPresent()) {
            return Option.some((Object)foundDescriptorOptional.get());
        }
        return Option.none();
    }

    <T, K extends AbstractHandlerModuleDescriptor<T>> Option<MailHandlerWrapper<T>> getHandler(String moduleCompleteKey, Class<K> clazz) {
        Option<K> foundDescriptorOption = this.getModuleDescriptor(moduleCompleteKey, clazz);
        if (foundDescriptorOption.isEmpty()) {
            this.logger.debug("Cannot find enabled module with complete key '{}' with class '{}'", (Object)moduleCompleteKey, (Object)clazz.getName());
            return Option.none();
        }
        AbstractHandlerModuleDescriptor foundDescriptor = (AbstractHandlerModuleDescriptor)foundDescriptorOption.get();
        try {
            Object handler = ComponentAccessor.getComponentClassManager().newInstanceFromPlugin(foundDescriptor.getHandlerClass(), foundDescriptor.getPlugin());
            if (handler != null) {
                return Option.some((Object)new MailHandlerWrapper(handler, foundDescriptor.getI18nNameKey()));
            }
            return Option.none();
        }
        catch (RuntimeException e) {
            this.logger.error(String.format("Plugin '%s' cannot create a new instance of class '%s'.", foundDescriptor.getPlugin(), foundDescriptor.getHandlerClass().getName()), (Throwable)e);
            return Option.none();
        }
    }
}

