/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.scheduler.timedpromise.internal.store.rows;

import com.atlassian.scheduler.timedpromise.internal.schema.querydsl.QTimedPromise;
import com.atlassian.util.concurrent.Assertions;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import io.atlassian.fugue.Option;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TimedPromiseRow {
    private final long id;
    private final String hash;
    private final String taskKey;
    private final String classification;
    private final long targetTimeMillis;
    private final Option<String> mimeType;
    private final Option<String> content;
    private final String status;
    private final long createdTimeMillis;
    private final long updatedTimeMillis;

    private TimedPromiseRow(Integer id, String hash, String taskKey, String classification, @Nullable Long targetTimeMillis, String mimeType, String content, String status, @Nullable Long createdTimeMillis, @Nullable Long updatedTimeMillis) {
        this.id = ((Integer)Assertions.notNull((String)"id", (Object)id)).intValue();
        this.hash = (String)Assertions.notNull((String)"hash", (Object)hash);
        this.taskKey = (String)Assertions.notNull((String)"taskKey", (Object)taskKey);
        this.classification = (String)Assertions.notNull((String)"classification", (Object)classification);
        this.targetTimeMillis = (Long)Option.option((Object)targetTimeMillis).getOrElse((Object)0L);
        this.mimeType = Option.option((Object)mimeType);
        this.content = Option.option((Object)content);
        this.status = (String)Assertions.notNull((String)"status", (Object)status);
        this.createdTimeMillis = (Long)Option.option((Object)createdTimeMillis).getOrElse((Object)0L);
        this.updatedTimeMillis = (Long)Option.option((Object)updatedTimeMillis).getOrElse((Object)0L);
    }

    public static TimedPromiseRow fromDatabase(@Nonnull QTimedPromise promiseTable, @Nonnull Tuple row) {
        Assertions.notNull((String)"row is required", (Object)row);
        Assertions.notNull((String)"promiseTable is required", (Object)((Object)promiseTable));
        return new TimedPromiseRow((Integer)row.get(promiseTable.ID), (String)row.get((Expression)promiseTable.KEY_HASH), (String)row.get((Expression)promiseTable.TASK_KEY), (String)row.get((Expression)promiseTable.CLASSIFICATION), (Long)row.get(promiseTable.TARGET_TIME_MILLIS), (String)row.get((Expression)promiseTable.MIME_TYPE), (String)row.get((Expression)promiseTable.CONTENT), (String)row.get((Expression)promiseTable.STATUS), (Long)row.get(promiseTable.CREATED_TIME_MILLIS), (Long)row.get(promiseTable.UPDATED_TIME_MILLIS));
    }

    public static Path<?>[] getColumns(QTimedPromise promiseTable) {
        Assertions.notNull((String)"promiseTable", (Object)((Object)promiseTable));
        return new Path[]{promiseTable.ID, promiseTable.TASK_KEY, promiseTable.CLASSIFICATION, promiseTable.KEY_HASH, promiseTable.TARGET_TIME_MILLIS, promiseTable.STATUS, promiseTable.MIME_TYPE, promiseTable.CONTENT, promiseTable.CREATED_TIME_MILLIS, promiseTable.UPDATED_TIME_MILLIS};
    }

    public long getId() {
        return this.id;
    }

    public String getHash() {
        return this.hash;
    }

    public String getTaskKey() {
        return this.taskKey;
    }

    public String getClassification() {
        return this.classification;
    }

    public long getTargetTimeMillis() {
        return this.targetTimeMillis;
    }

    public Option<String> getMimeType() {
        return this.mimeType;
    }

    public Option<String> getContent() {
        return this.content;
    }

    public String getStatus() {
        return this.status;
    }

    public long getCreatedTimeMillis() {
        return this.createdTimeMillis;
    }

    public long getUpdatedTimeMillis() {
        return this.updatedTimeMillis;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TimedPromiseRow)) {
            return false;
        }
        TimedPromiseRow that = (TimedPromiseRow)o;
        if (this.createdTimeMillis != that.createdTimeMillis) {
            return false;
        }
        if (this.id != that.id) {
            return false;
        }
        if (this.targetTimeMillis != that.targetTimeMillis) {
            return false;
        }
        if (this.updatedTimeMillis != that.updatedTimeMillis) {
            return false;
        }
        if (!this.classification.equals(that.classification)) {
            return false;
        }
        if (this.content != null ? !this.content.equals(that.content) : that.content != null) {
            return false;
        }
        if (!this.hash.equals(that.hash)) {
            return false;
        }
        if (this.mimeType != null ? !this.mimeType.equals(that.mimeType) : that.mimeType != null) {
            return false;
        }
        if (!this.status.equals(that.status)) {
            return false;
        }
        return this.taskKey.equals(that.taskKey);
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = 31 * result + this.hash.hashCode();
        result = 31 * result + this.taskKey.hashCode();
        result = 31 * result + this.classification.hashCode();
        result = 31 * result + (int)(this.targetTimeMillis ^ this.targetTimeMillis >>> 32);
        result = 31 * result + (this.mimeType != null ? this.mimeType.hashCode() : 0);
        result = 31 * result + (this.content != null ? this.content.hashCode() : 0);
        result = 31 * result + this.status.hashCode();
        result = 31 * result + (int)(this.createdTimeMillis ^ this.createdTimeMillis >>> 32);
        result = 31 * result + (int)(this.updatedTimeMillis ^ this.updatedTimeMillis >>> 32);
        return result;
    }
}

