/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.scheduler.timedpromise.internal.history.store.parser;

import com.atlassian.scheduler.timedpromise.api.TimedPromise;
import com.atlassian.scheduler.timedpromise.api.TimedPromiseConfig;
import com.atlassian.scheduler.timedpromise.api.TimedPromiseKey;
import com.atlassian.scheduler.timedpromise.internal.TimedPromiseImpl;
import com.atlassian.scheduler.timedpromise.internal.history.store.rows.TimedPromiseHistoryRecordRow;
import com.atlassian.scheduler.timedpromise.internal.schema.querydsl.QHistoryRecord;
import com.atlassian.scheduler.timedpromise.spi.history.HistoryEventType;
import com.atlassian.scheduler.timedpromise.spi.history.TimedPromiseHistoryRecord;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.collect.Lists;
import com.querydsl.core.Tuple;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.joda.time.DateTime;

public class TimedPromiseHistoryRecordParser {
    public static List<TimedPromiseHistoryRecord> parseResultStream(@Nonnull QHistoryRecord historyRecordTable, @Nonnull List<Tuple> results, @Nonnull TimedPromiseKey timedPromiseKey) {
        Assertions.notNull((String)"results is required", results);
        Assertions.notNull((String)"timedPromiseKey is required", (Object)timedPromiseKey);
        Assertions.notNull((String)"historyRecordTable is required", (Object)((Object)historyRecordTable));
        ArrayList historyRecordList = Lists.newArrayList();
        List rows = results.stream().map(input -> TimedPromiseHistoryRecordRow.fromDatabase(historyRecordTable, input)).collect(Collectors.toList());
        for (TimedPromiseHistoryRecordRow parsedRow : rows) {
            historyRecordList.add(TimedPromiseHistoryRecordParser.buildHistoryRecord(parsedRow, timedPromiseKey));
        }
        return historyRecordList;
    }

    private static TimedPromiseHistoryRecord buildHistoryRecord(TimedPromiseHistoryRecordRow historyRecordRow, TimedPromiseKey timedPromiseKey) {
        return TimedPromiseHistoryRecord.builder().eventTime(new DateTime(historyRecordRow.getEventTimeMillis())).eventType(HistoryEventType.forKey((String)historyRecordRow.getEventType())).message(historyRecordRow.getMessage()).timedPromise(TimedPromiseHistoryRecordParser.buildArchivedTimedPromise(historyRecordRow, timedPromiseKey)).build();
    }

    private static TimedPromise buildArchivedTimedPromise(TimedPromiseHistoryRecordRow historyRecordRow, TimedPromiseKey timedPromiseKey) {
        TimedPromiseConfig timedPromiseConfig = TimedPromiseConfig.builder().invocationTime(historyRecordRow.getTargetTimeMillis()).build();
        return TimedPromiseImpl.builder().key(timedPromiseKey).config(timedPromiseConfig).build();
    }
}

