/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.scheduler.timedpromise.internal.history;

import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.scheduler.timedpromise.api.TimedPromise;
import com.atlassian.scheduler.timedpromise.api.TimedPromiseKey;
import com.atlassian.scheduler.timedpromise.internal.TimedPromiseKeyHasher;
import com.atlassian.scheduler.timedpromise.internal.history.store.parser.TimedPromiseHistoryRecordParser;
import com.atlassian.scheduler.timedpromise.internal.history.store.rows.TimedPromiseHistoryRecordRow;
import com.atlassian.scheduler.timedpromise.internal.schema.QueryDslService;
import com.atlassian.scheduler.timedpromise.internal.schema.querydsl.Tables;
import com.atlassian.scheduler.timedpromise.internal.store.TimedPromiseQueryDslDao;
import com.atlassian.scheduler.timedpromise.spi.TimedPromiseHistoryDao;
import com.atlassian.scheduler.timedpromise.spi.history.HistoryEventType;
import com.atlassian.scheduler.timedpromise.spi.history.TimedPromiseHistoryRecord;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.collect.Lists;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Unit;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class TimedPromiseHistoryDaoImpl
extends TimedPromiseQueryDslDao
implements TimedPromiseHistoryDao {
    private static final Logger LOG = LoggerFactory.getLogger(TimedPromiseHistoryDaoImpl.class);
    public static final int DELETION_BATCH_SIZE = 500;
    private final TimedPromiseKeyHasher keyHasher;

    @Autowired
    public TimedPromiseHistoryDaoImpl(QueryDslService queryDslService, TimedPromiseKeyHasher keyHasher) {
        super(queryDslService);
        Assertions.notNull((String)"keyHasher is required", (Object)keyHasher);
        this.keyHasher = keyHasher;
    }

    public TimedPromiseHistoryRecord createHistoryRecord(@Nonnull TimedPromiseHistoryRecord timedPromiseHistoryRecord) {
        Assertions.notNull((String)"timedPromiseHistoryRecord", (Object)timedPromiseHistoryRecord);
        return this.queryDslService.runInTransaction(connection -> {
            long rowsAffected;
            try {
                rowsAffected = this.queryDslService.insert((DatabaseConnection)connection, (RelationalPath<?>)Tables.HISTORY_RECORD).set((Path)Tables.HISTORY_RECORD.TIMED_PROMISE_HISTORY_KEY_HASH, (Object)this.keyHasher.hash(timedPromiseHistoryRecord.getTimedPromise().getKey())).set((Path)Tables.HISTORY_RECORD.EVENT_TYPE, (Object)timedPromiseHistoryRecord.getEventType().getKey()).set(Tables.HISTORY_RECORD.EVENT_TIME_MILLIS, (Object)timedPromiseHistoryRecord.getEventTime().getMillis()).set((Path)Tables.HISTORY_RECORD.MESSAGE, (Object)timedPromiseHistoryRecord.getMessage()).set(Tables.HISTORY_RECORD.TARGET_TIME_MILLIS, (Object)timedPromiseHistoryRecord.getTimedPromise().getScheduledInvocationTime()).execute();
            }
            catch (RuntimeException sqlException) {
                throw new RuntimeException("Failed to insert Timed Promise history record.", sqlException);
            }
            if (rowsAffected != 1L) {
                throw new RuntimeException("Expected 1 Timed Promise history row inserted, but received " + rowsAffected);
            }
            return timedPromiseHistoryRecord;
        });
    }

    public TimedPromise createArchivedTimedPromise(@Nonnull TimedPromise timedPromise) {
        Assertions.notNull((String)"timedPromise", (Object)timedPromise);
        Option<Integer> insertedIdOpt = this.insertTimedPromise(timedPromise);
        if (insertedIdOpt.isDefined()) {
            this.insertChildComponents((Integer)insertedIdOpt.get(), timedPromise.getKey().getComponents());
        }
        return timedPromise;
    }

    public boolean archivedTimedPromiseExists(@Nonnull TimedPromise timedPromise) {
        Assertions.notNull((String)"timedPromise", (Object)timedPromise);
        return this.getTimedPromiseHistoryId(timedPromise.getKey()).isDefined();
    }

    public List<TimedPromiseHistoryRecord> getHistoryRecords(@Nonnull TimedPromiseKey timedPromiseKey) {
        Assertions.notNull((String)"timedPromiseKey", (Object)timedPromiseKey);
        List tuples = this.queryDslService.run(connection -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)connection.select(TimedPromiseHistoryRecordRow.getColumns(Tables.HISTORY_RECORD)).from((Expression)Tables.HISTORY_RECORD)).where((Predicate)Tables.HISTORY_RECORD.TIMED_PROMISE_HISTORY_KEY_HASH.eq((Object)this.keyHasher.hash(timedPromiseKey)))).orderBy(Tables.HISTORY_RECORD.EVENT_TIME_MILLIS.desc())).orderBy(Tables.HISTORY_RECORD.ID.desc())).fetch());
        return TimedPromiseHistoryRecordParser.parseResultStream(Tables.HISTORY_RECORD, tuples, timedPromiseKey);
    }

    public void deleteOlderThan(long duration, TimeUnit unit) {
        int deleted;
        Assertions.isTrue((String)"duration cannot be negative", (duration >= 0L ? 1 : 0) != 0);
        Assertions.notNull((String)"unit", (Object)((Object)unit));
        Duration cutoffDuration = Duration.millis((long)TimeUnit.MILLISECONDS.convert(duration, unit));
        long cutoffTime = DateTime.now().minus((ReadableDuration)cutoffDuration).getMillis();
        while ((deleted = this.deleteBatch(cutoffTime, 500)) != 0) {
        }
    }

    private int deleteBatch(long cutoffTime, int batchSize) {
        return this.queryDslService.runInTransaction(conn -> {
            List tuples = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)conn.select(new Expression[]{Tables.PROMISE_HISTORY.ID, Tables.HISTORY_RECORD.TIMED_PROMISE_HISTORY_KEY_HASH}).from((Expression)Tables.HISTORY_RECORD)).leftJoin((EntityPath)Tables.PROMISE_HISTORY)).on((Predicate)Tables.HISTORY_RECORD.TIMED_PROMISE_HISTORY_KEY_HASH.eq((Expression)Tables.PROMISE_HISTORY.KEY_HASH))).groupBy(new Expression[]{Tables.HISTORY_RECORD.TIMED_PROMISE_HISTORY_KEY_HASH, Tables.PROMISE_HISTORY.ID})).having((Predicate)Tables.HISTORY_RECORD.TARGET_TIME_MILLIS.max().lt((Number)cutoffTime))).limit((long)batchSize)).fetch();
            if (tuples.isEmpty()) {
                return 0;
            }
            List promiseIds = tuples.stream().map(tuple -> (Integer)tuple.get(Tables.PROMISE_HISTORY.ID)).filter(Objects::nonNull).collect(Collectors.toList());
            if (!promiseIds.isEmpty()) {
                conn.delete((RelationalPath)Tables.KEY_COMPONENT_HISTORY).where((Predicate)Tables.KEY_COMPONENT_HISTORY.TIMED_PROMISE_ID.in(promiseIds)).execute();
                conn.delete((RelationalPath)Tables.PROMISE_HISTORY).where((Predicate)Tables.PROMISE_HISTORY.ID.in(promiseIds)).execute();
            }
            List keyHashes = tuples.stream().map(tuple -> (String)tuple.get((Expression)Tables.HISTORY_RECORD.TIMED_PROMISE_HISTORY_KEY_HASH)).collect(Collectors.toList());
            conn.delete((RelationalPath)Tables.HISTORY_RECORD).where((Predicate)Tables.HISTORY_RECORD.TIMED_PROMISE_HISTORY_KEY_HASH.in(keyHashes)).execute();
            return tuples.size();
        });
    }

    public long recordMultipleEvents(@Nonnull List<TimedPromise> timedPromises, @Nonnull HistoryEventType eventType, @Nonnull String reason) {
        Assertions.notNull((String)"timedPromises", timedPromises);
        Assertions.notNull((String)"eventType", (Object)eventType);
        Assertions.notNull((String)"reason", (Object)reason);
        if (timedPromises.isEmpty()) {
            return 0L;
        }
        List<List<TimedPromise>> timedPromiseBatches = this.batchTimedPromises(timedPromises);
        return this.queryDslService.runInTransaction(connection -> {
            long rowsAffected = 0L;
            try {
                SQLInsertClause insert = this.queryDslService.insert((DatabaseConnection)connection, (RelationalPath<?>)Tables.HISTORY_RECORD);
                for (List timedPromiseBatch : timedPromiseBatches) {
                    rowsAffected = this.insertHistoryRecordBatch(timedPromiseBatch, eventType, reason, insert);
                }
            }
            catch (RuntimeException sqlException) {
                throw new RuntimeException("Failed to insert Timed Promise history record(s).", sqlException);
            }
            if (rowsAffected != (long)timedPromises.size()) {
                throw new RuntimeException("Expected " + timedPromises.size() + " Timed Promise history row(s) inserted, but received " + rowsAffected);
            }
            return rowsAffected;
        });
    }

    private List<List<TimedPromise>> batchTimedPromises(List<TimedPromise> timedPromises) {
        int listSize = timedPromises.size();
        int BATCH_SIZE = 2000;
        ArrayList batchedTimedPromises = Lists.newArrayList();
        for (int startIndex = 0; startIndex < listSize; startIndex += 2000) {
            batchedTimedPromises.add(timedPromises.subList(startIndex, Math.min(startIndex + 2000, listSize)));
        }
        return batchedTimedPromises;
    }

    private long insertHistoryRecordBatch(List<TimedPromise> timedPromiseBatch, HistoryEventType eventType, String message, SQLInsertClause insert) {
        for (TimedPromise timedPromise : timedPromiseBatch) {
            insert.set((Path)Tables.HISTORY_RECORD.TIMED_PROMISE_HISTORY_KEY_HASH, (Object)this.keyHasher.hash(timedPromise.getKey()));
            insert.set((Path)Tables.HISTORY_RECORD.EVENT_TYPE, (Object)eventType.getKey());
            insert.set(Tables.HISTORY_RECORD.EVENT_TIME_MILLIS, (Object)DateTime.now().getMillis());
            insert.set((Path)Tables.HISTORY_RECORD.MESSAGE, (Object)message);
            insert.set(Tables.HISTORY_RECORD.TARGET_TIME_MILLIS, (Object)timedPromise.getScheduledInvocationTime());
            insert.addBatch();
        }
        return insert.execute();
    }

    private Option<Integer> insertTimedPromise(TimedPromise timedPromise) {
        try {
            this.queryDslService.runInTransaction(connection -> {
                Long rowsAffected = this.queryDslService.insert((DatabaseConnection)connection, (RelationalPath<?>)Tables.PROMISE_HISTORY).set((Path)Tables.PROMISE_HISTORY.KEY_HASH, (Object)this.keyHasher.hash(timedPromise.getKey())).set((Path)Tables.PROMISE_HISTORY.TASK_KEY, (Object)timedPromise.getKey().getTaskRunnerKey().toString()).set((Path)Tables.PROMISE_HISTORY.CLASSIFICATION, (Object)timedPromise.getKey().getClassification().getName()).execute();
                if (rowsAffected != 1L) {
                    throw new RuntimeException("Expected 1 Timed Promise history row inserted, but received " + rowsAffected);
                }
                return rowsAffected;
            });
        }
        catch (RuntimeException sqlException) {
            LOG.debug("Unable to insert timed promise history", (Throwable)sqlException);
            if (this.getTimedPromiseHistoryId(timedPromise.getKey()).isDefined()) {
                return Option.none();
            }
            throw new RuntimeException("Failed to insert Timed Promise history.", sqlException);
        }
        Option<Integer> insertedIdOpt = this.getTimedPromiseHistoryId(timedPromise.getKey());
        if (insertedIdOpt.isEmpty()) {
            throw new RuntimeException("Failed to retrieve Timed Promise history row after insertion.");
        }
        return insertedIdOpt;
    }

    private Option<Integer> getTimedPromiseHistoryId(TimedPromiseKey timedPromiseKey) {
        return this.queryDslService.runInTransaction(connection -> Option.option((Object)((SQLQuery)((SQLQuery)connection.select(Tables.PROMISE_HISTORY.ID).from((Expression)Tables.PROMISE_HISTORY)).where((Predicate)Tables.PROMISE_HISTORY.KEY_HASH.eq((Object)this.keyHasher.hash(timedPromiseKey)))).fetchOne()));
    }

    private void insertChildComponents(int parentId, TimedPromiseKey.Components components) {
        this.queryDslService.runInTransaction(connection -> {
            for (String key : components.listKeys()) {
                long rowsInserted = this.queryDslService.insert((DatabaseConnection)connection, (RelationalPath<?>)Tables.KEY_COMPONENT_HISTORY).set(Tables.KEY_COMPONENT_HISTORY.TIMED_PROMISE_ID, (Object)parentId).set((Path)Tables.KEY_COMPONENT_HISTORY.KEY, (Object)key).set((Path)Tables.KEY_COMPONENT_HISTORY.VALUE, components.get(key).getOrNull()).execute();
                if (rowsInserted == 1L) continue;
                throw new RuntimeException("Expected 1 inserted component, but received " + rowsInserted);
            }
            return Unit.VALUE;
        });
    }
}

